/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.Case;
import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class WW
extends ContextFreePumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "ww : w element_of {ab}*";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>ww</i> : <i>w</i> " + ELEMENT_OF + " " + AB_STAR;
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i></sup>a<sup><i>m</i></sup>b<sup><i>m</i></sup>\".  To be in the language with this example, <i>v</i> & <i>y</i> together cannot possess identical letters that are from separate blocks of alike letters (ex: <i>v</i> has \"b\"s from the first set of \"b\"s, while <i>y</i> has \"b\"s from the second set of \"b\"s.  Because of this, any increase or decrease in \"a\"s or \"b\"s will not be matched by any corresponding change in the other blocks of similar letters, resulting in an inequality that prevents the decomposition from working.  Thus, this language is not context-free.";
    }

    @Override
    protected void chooseW() {
        this.w = String.valueOf(WW.pumpString("a", this.getM())) + WW.pumpString("b", this.getM()) + WW.pumpString("a", this.getM()) + WW.pumpString("b", this.getM());
    }

    @Override
    public void chooseDecomposition() {
        int half = this.w.length() / 2;
        if (this.m > half) {
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArray[2] = half - 1;
            nArray[3] = 1;
            this.setDecomposition(nArray);
            return;
        }
        int i = half - this.m + 1;
        while (i < half) {
            int j = 0;
            while (j < i) {
                if (this.w.charAt(i) == this.w.charAt(j)) {
                    String first = String.valueOf(this.w.substring(0, i)) + WW.pumpString("" + this.w.charAt(i), 2) + this.w.substring(i + 1, half);
                    String last = String.valueOf(this.w.substring(0, j)) + WW.pumpString("" + this.w.charAt(j), 2) + this.w.substring(j + 1, half);
                    int x = half - i + j - 1;
                    if (first.equals(last) && x <= this.m - 2) {
                        this.setDecomposition(new int[]{i, 1, x, 1});
                        return;
                    }
                }
                ++j;
            }
            ++i;
        }
        super.chooseDecomposition();
    }

    @Override
    public void chooseI() {
        this.i = 0;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 6};
    }

    @Override
    protected void addCases() {
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && y.indexOf("a") > -1 && y.indexOf("b") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && y.indexOf("a") > -1 && y.indexOf("b") > -1 && y.indexOf("a") < y.indexOf("b");
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s followed by \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 1;
                nArray[1] = 1;
                nArray[3] = WW.this.m - 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = WW.this.m - 1;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") > -1 && v.indexOf("a") < v.indexOf("b") && y.indexOf("a") == -1 && y.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s followed by \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = WW.this.m - 1;
                nArray[1] = 2;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = WW.this.m;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && y.indexOf("a") > -1 && y.indexOf("b") > -1 && y.indexOf("a") > y.indexOf("b");
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s followed by \"a\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * WW.this.m - 2;
                nArray[1] = 1;
                nArray[3] = 2;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && y.indexOf("a") > -1 && y.indexOf("b") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * WW.this.m - 1;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") > -1 && v.indexOf("a") > v.indexOf("b") && y.indexOf("a") > -1 && y.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s followed by \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * WW.this.m - 1;
                nArray[1] = 2;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.length() == 0 && y.length() > 0;
            }

            @Override
            public String description() {
                return "v is an empty string and y is a non-empty string";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * WW.this.m;
                nArray[2] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.length() > 0 && y.length() == 0;
            }

            @Override
            public String description() {
                return "v is a non-empty string and y is an empty string";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * WW.this.m;
                nArray[1] = 1;
                return nArray;
            }
        });
    }

    @Override
    public boolean isInLang(String s) {
        String last;
        char[] list = new char[]{'a', 'b'};
        if (LemmaMath.otherCharactersFound(s, list)) {
            return false;
        }
        int halfSize = s.length() / 2;
        String first = s.substring(0, halfSize);
        return first.equals(last = s.substring(halfSize));
    }
}

