/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class W1BnW2
extends ContextFreePumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "w1 + b^n + w2 : na(w1) < na(w2) & na(w1) < n, w1 & w2 element_of {ab}*";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>w<sub>1</sub>b<sup>n</sup>w<sub>2</sub></i> : <i>n<sub>a</sub></i>(<i>w<sub>1</sub></i>) " + LESS_THAN + " <i>n<sub>a</sub></i>(<i>w<sub>2</sub></i>" + "),  n<sub>a</sub>(<i>w<sub>1</sub></i>) " + LESS_THAN + " <i>n</i>, " + "<i>w<sub>1</sub></i> & <i>w<sub>2</sub></i> " + ELEMENT_OF + " " + AB_STAR;
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i>+1</sup>a<sup><i>m</i>+1</sup>\".  To be in the language with this example, <i>v</i> & <i>y</i> together cannot possess substrings that are from 'w'<sub>1</sub>, from b<sup>n</sup>, and from 'w<sub>2</sub>'.  Thus, if <i>i</i> = 0, <i>i</i> = 2, or perhaps both, either <i>v</i> or <i>y</i> will violate one of the conditions, meaning there is no valid decomposition.  Thus, this language is not context-free.";
    }

    @Override
    protected void addCases() {
    }

    @Override
    protected void chooseW() {
        this.w = String.valueOf(W1BnW2.pumpString("a", this.m)) + W1BnW2.pumpString("b", this.m + 1) + W1BnW2.pumpString("a", this.m + 1);
    }

    @Override
    public void chooseDecomposition() {
        int k = this.w.length() - 1;
        while (k >= 0) {
            String s = String.valueOf(this.w.substring(0, k)) + this.w.substring(k + 1);
            if (this.isInLang(s)) {
                int[] nArray = new int[4];
                nArray[0] = k;
                nArray[1] = 1;
                this.setDecomposition(nArray);
                return;
            }
            --k;
        }
        super.chooseDecomposition();
    }

    @Override
    public void chooseI() {
        this.i = this.getU().length() < this.m ? 2 : 0;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 10};
    }

    @Override
    public boolean isInLang(String s) {
        char[] list = new char[]{'a', 'b'};
        if (LemmaMath.otherCharactersFound(s, list)) {
            return false;
        }
        String temp = null;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == 'b') {
                int a2;
                temp = new String();
                while (i < s.length() && s.charAt(i) == 'b') {
                    temp = String.valueOf(temp) + 'b';
                    ++i;
                }
                String w1 = s.substring(0, i - temp.length());
                String w2 = i != s.length() ? s.substring(i) : "";
                int a1 = LemmaMath.countInstances(w1, 'a');
                if (a1 < (a2 = LemmaMath.countInstances(w2, 'a')) && temp.length() > a1) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

