/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.Case;
import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class NagNbeNc
extends ContextFreePumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "w element_of {abc}* : na(w) > nb(w) = nc(w)";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>w</i> " + ELEMENT_OF + " {<i>a</i>, <i>b</i>, <i>c</i>}* :" + " <i>n<sub>a</sub></i> (<i>w</i>) " + GREATER_THAN + " <i>n<sub>b</sub></i> (<i>w</i>) = <i>n<sub>c</sub></i> (<i>w</i>)";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i>+1</sup>b<sup><i>m</i></sup>c<sup><i>m</i></sup>\".  With this example, it is impossible to have \"a\"s, \"b\"s, and \"c\"s in both <i>v</i> and <i>y</i> together.  Thus, if <i>i</i> = 0, <i>i</i> = 2, or perhaps both, one of the inequalities will be violated, meaning there is no valid decomposition.  Thus, this language is not context-free.";
    }

    @Override
    protected void chooseW() {
        this.w = String.valueOf(NagNbeNc.pumpString("a", this.getM() + 1)) + NagNbeNc.pumpString("b", this.getM()) + NagNbeNc.pumpString("c", this.getM());
    }

    @Override
    public void chooseDecomposition() {
        int b;
        int a = LemmaMath.countInstances(this.w, 'a');
        if (a > (b = LemmaMath.countInstances(this.w, 'b')) + 1) {
            int[] nArray = new int[4];
            nArray[1] = 1;
            this.setDecomposition(nArray);
        } else {
            super.chooseDecomposition();
        }
    }

    @Override
    public void chooseI() {
        this.i = this.getV().indexOf("a") == -1 && this.getY().indexOf("a") == -1 ? 2 : 0;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 7};
    }

    @Override
    protected void addCases() {
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && v.indexOf("c") == -1 && y.indexOf("a") > -1 && y.indexOf("b") == -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && v.indexOf("c") == -1 && y.indexOf("a") > -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s followed by \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = NagNbeNc.this.m - 1;
                nArray[1] = 1;
                nArray[3] = 2;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = NagNbeNc.this.m;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s followed by \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = NagNbeNc.this.m;
                nArray[1] = 2;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = NagNbeNc.this.m + 1;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s followed by \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * NagNbeNc.this.m - 1;
                nArray[1] = 1;
                nArray[3] = 2;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * NagNbeNc.this.m;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") > -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s followed by \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * NagNbeNc.this.m;
                nArray[1] = 2;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") == -1 && v.indexOf("c") > -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * NagNbeNc.this.m + 1;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.length() == 0 && y.length() > 0;
            }

            @Override
            public String description() {
                return "v is an empty string and y is a non-empty string";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * NagNbeNc.this.m;
                nArray[2] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.length() > 0 && y.length() == 0;
            }

            @Override
            public String description() {
                return "v is a non-empty string and y is an empty string";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * NagNbeNc.this.m;
                nArray[1] = 1;
                return nArray;
            }
        });
    }

    @Override
    public boolean isInLang(String s) {
        char[] list = new char[]{'a', 'b', 'c'};
        if (LemmaMath.otherCharactersFound(s, list)) {
            return false;
        }
        int a = LemmaMath.countInstances(s, 'a');
        int b = LemmaMath.countInstances(s, 'b');
        int c = LemmaMath.countInstances(s, 'c');
        return a > b && b == c;
    }
}

