/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.Case;
import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class AnBjAnBj
extends ContextFreePumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "a^n b^j a^n b^j : n >= 0, j >= 0";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>n</sup>b<sup>j</sup>a<sup>n</sup>b<sup>j</sup></i> : <i>n</i> " + GREATER_OR_EQ + " 0, <i>j</i> " + GREATER_OR_EQ + " 0";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i></sup>a<sup><i>m</i></sup>b<sup><i>m</i></sup>\".  To be in the language with this example, <i>v</i> & <i>y</i> together cannot possess identical letters that are from separate blocks of alike letters (ex: <i>v</i> has \"b\"s from the first set of \"b\"s, while <i>y</i> has \"b\"s from the second set of \"b\"s).  Because of this, any increase or decrease in \"a\"s or \"b\"s will not be matched by any change in the other blocks of similar letters, resulting in an inequality that prevents the decomposition from working.  Thus, this language is not context-free.";
    }

    @Override
    protected void chooseW() {
        this.w = String.valueOf(AnBjAnBj.pumpString("a", this.getM())) + AnBjAnBj.pumpString("b", this.getM()) + AnBjAnBj.pumpString("a", this.getM()) + AnBjAnBj.pumpString("b", this.getM());
    }

    @Override
    public void chooseDecomposition() {
        int step = this.w.length() / 2 - 1;
        if (step > this.m - 2) {
            step = this.m - 2;
        }
        if (this.w.indexOf(97) > -1) {
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArray[2] = step;
            nArray[3] = 1;
            this.setDecomposition(nArray);
        } else {
            this.setDecomposition(new int[]{this.w.indexOf(98), 1, step, 1});
        }
    }

    @Override
    public void chooseI() {
        this.i = 0;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 5};
    }

    @Override
    protected void addCases() {
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && y.indexOf("a") > -1 && y.indexOf("b") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && y.indexOf("a") > -1 && y.indexOf("b") > -1 && y.indexOf("a") < y.indexOf("b");
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s followed by \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 1;
                nArray[1] = 1;
                nArray[3] = AnBjAnBj.this.m - 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = AnBjAnBj.this.m - 1;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") > -1 && v.indexOf("a") < v.indexOf("b") && y.indexOf("a") == -1 && y.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s followed by \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = AnBjAnBj.this.m - 1;
                nArray[1] = 2;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = AnBjAnBj.this.m;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && y.indexOf("a") > -1 && y.indexOf("b") > -1 && y.indexOf("a") > y.indexOf("b");
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s followed by \"a\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AnBjAnBj.this.m - 2;
                nArray[1] = 1;
                nArray[3] = 2;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && y.indexOf("a") > -1 && y.indexOf("b") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AnBjAnBj.this.m - 1;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") > -1 && v.indexOf("a") > v.indexOf("b") && y.indexOf("a") > -1 && y.indexOf("b") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s followed by \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AnBjAnBj.this.m - 1;
                nArray[1] = 2;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.length() == 0 && y.length() > 0;
            }

            @Override
            public String description() {
                return "v is an empty string and y is a non-empty string";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AnBjAnBj.this.m;
                nArray[2] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.length() > 0 && y.length() == 0;
            }

            @Override
            public String description() {
                return "v is a non-empty string and y is an empty string";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AnBjAnBj.this.m;
                nArray[1] = 1;
                return nArray;
            }
        });
    }

    @Override
    public boolean isInLang(String s) {
        String last;
        int halfSize = s.length() / 2;
        String first = s.substring(0, halfSize);
        if (!first.equals(last = s.substring(halfSize))) {
            return false;
        }
        char[] list = new char[]{'a', 'b'};
        return !LemmaMath.isMixture(first, list) && !LemmaMath.isMixture(last, list);
    }
}

