/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class Trees {
    private Trees() {
    }

    public static TreeNode[] children(TreeNode node) {
        TreeNode[] children = new TreeNode[node.getChildCount()];
        if (!node.isLeaf()) {
            int i = 0;
            Enumeration<? extends TreeNode> enumer = node.children();
            while (i < children.length) {
                children[i++] = enumer.nextElement();
            }
        }
        return children;
    }

    public static int[] width(TreeModel tree) {
        int[] width = new int[Trees.depth(tree) + 1];
        Arrays.fill(width, 0);
        Trees.width((TreeNode)tree.getRoot(), 0, width);
        return width;
    }

    private static void width(TreeNode node, int depth, int[] array) {
        int n = depth++;
        array[n] = array[n] + 1;
        if (node.isLeaf()) {
            return;
        }
        TreeNode[] children = Trees.children(node);
        int i = 0;
        while (i < children.length) {
            Trees.width(children[i], depth, array);
            ++i;
        }
    }

    public static int depth(TreeModel tree) {
        return Trees.depth((TreeNode)tree.getRoot());
    }

    public static int depth(TreeNode node) {
        TreeNode[] children = Trees.children(node);
        int max = -1;
        int i = 0;
        while (i < children.length) {
            max = Math.max(max, Trees.depth(children[i]));
            ++i;
        }
        return max + 1;
    }

    public static TreeNode[] leaves(TreeModel tree) {
        return Trees.leaves((TreeNode)tree.getRoot());
    }

    public static TreeNode[] leaves(TreeNode node) {
        TreeNode[] children = Trees.children(node);
        if (children.length == 0) {
            return new TreeNode[]{node};
        }
        ArrayList<TreeNode> leaves = new ArrayList<TreeNode>();
        int i = 0;
        while (i < children.length) {
            TreeNode[] subleaves = Trees.leaves(children[i]);
            int j = 0;
            while (j < subleaves.length) {
                leaves.add(subleaves[j]);
                ++j;
            }
            ++i;
        }
        return leaves.toArray(new TreeNode[0]);
    }
}

