/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import gui.tree.DefaultNodeDrawer;
import gui.tree.DefaultNodePlacer;
import gui.tree.NodeDrawer;
import gui.tree.NodePlacer;
import gui.tree.TreeDrawer;
import gui.tree.Trees;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class DefaultTreeDrawer
implements TreeDrawer,
TreeModelListener {
    private boolean inverted = false;
    private boolean valid = false;
    private TreeModel tree;
    private Map<TreeNode, Point2D.Float> nodeToPoint = new HashMap<TreeNode, Point2D.Float>();
    private boolean defaultVisible = true;
    private WeakHashMap<TreeNode, ?> visibleNodes = new WeakHashMap();
    private NodeDrawer nodeDrawer = new DefaultNodeDrawer();
    private NodePlacer nodePlacer = new DefaultNodePlacer();

    public DefaultTreeDrawer(TreeModel tree) {
        this.tree = tree;
        tree.addTreeModelListener(this);
    }

    protected Color getNodeColor(TreeNode node) {
        return Color.yellow;
    }

    @Override
    public void draw(Graphics2D g, Dimension2D size) {
        if (!this.valid) {
            this.revalidate();
        }
        g = (Graphics2D)g.create();
        g.setFont(g.getFont().deriveFont(10.0f));
        g.setColor(Color.black);
        this.draw(g, (TreeNode)this.tree.getRoot(), size, null);
        g.dispose();
    }

    private Point2D scalePoint(Point2D point, Dimension2D size) {
        Point2D scale = null;
        try {
            scale = (Point2D)point.getClass().newInstance();
            if (this.inverted) {
                scale.setLocation(point.getX() * size.getWidth(), (1.0 - point.getY()) * size.getHeight());
            } else {
                scale.setLocation(point.getX() * size.getWidth(), point.getY() * size.getHeight());
            }
        }
        catch (Throwable e) {
            System.err.println("BADNESS SCALING THE POINT IN TREEDRAWER!");
            System.err.println(e);
        }
        return scale;
    }

    protected void draw(Graphics2D g, TreeNode node, Dimension2D size, Point2D parent) {
        boolean visible = this.isVisible(node);
        Point2D p = this.scalePoint(this.nodeToPoint.get(node), size);
        if (visible && parent != null) {
            g.drawLine((int)parent.getX(), (int)parent.getY(), (int)p.getX(), (int)p.getY());
        }
        TreeNode[] c = Trees.children(node);
        int i = 0;
        while (i < c.length) {
            this.draw(g, c[i], size, visible ? p : null);
            ++i;
        }
        if (!visible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(p.getX(), p.getY());
        g2.setColor(this.getNodeColor(node));
        this.nodeDrawer.draw(g2, node);
        g2.dispose();
    }

    @Override
    public TreeModel getModel() {
        return this.tree;
    }

    public void setModel(TreeModel model) {
        this.tree = model;
        this.invalidate();
    }

    public void hideAll() {
        this.defaultVisible = false;
        this.visibleNodes.clear();
    }

    public void showAll() {
        this.defaultVisible = true;
        this.visibleNodes.clear();
    }

    public void show(TreeNode node) {
        if (this.defaultVisible) {
            this.visibleNodes.remove(node);
        } else {
            this.visibleNodes.put(node, null);
        }
    }

    public void hide(TreeNode node) {
        this.defaultVisible = !this.defaultVisible;
        this.show(node);
        this.defaultVisible = !this.defaultVisible;
    }

    public boolean isVisible(TreeNode node) {
        return this.defaultVisible ^ this.visibleNodes.containsKey(node);
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public void revalidate() {
        this.valid = true;
        this.nodeToPoint = this.nodePlacer.placeNodes(this.tree, this.nodeDrawer);
        this.nodePlacer.placeNodes(this.tree, this.nodeDrawer);
    }

    @Override
    public TreeNode nodeAtPoint(Point2D point, Dimension2D size) {
        for (Map.Entry<TreeNode, Point2D.Float> entry : this.nodeToPoint.entrySet()) {
            Point2D p = this.scalePoint(entry.getValue(), size);
            TreeNode node = entry.getKey();
            if (!this.nodeDrawer.onNode(node, point.getX() - p.getX(), point.getY() - p.getY())) continue;
            return node;
        }
        return null;
    }

    private void setPoints(TreeNode node, int depth, int thisDepth, int[] width, int[] widthSofar) {
        float x = (float)(widthSofar[thisDepth] + 1) / (float)(width[thisDepth] + 1);
        float y = (float)(thisDepth + 1) / (float)(depth + 2);
        this.nodeToPoint.put(node, new Point2D.Float(x, y));
        int n = thisDepth++;
        widthSofar[n] = widthSofar[n] + 1;
        TreeNode[] children = Trees.children(node);
        int i = 0;
        while (i < children.length) {
            this.setPoints(children[i], depth, thisDepth, width, widthSofar);
            ++i;
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.invalidate();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.invalidate();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.invalidate();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.invalidate();
    }

    @Override
    public void setNodePlacer(NodePlacer placer) {
        this.nodePlacer = placer;
        this.invalidate();
    }

    @Override
    public NodePlacer getNodePlacer() {
        return this.nodePlacer;
    }

    @Override
    public void setNodeDrawer(NodeDrawer drawer) {
        this.nodeDrawer = drawer;
    }

    @Override
    public NodeDrawer getNodeDrawer() {
        return this.nodeDrawer;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public boolean isInverted() {
        return this.inverted;
    }
}

