/*
 * Decompiled with CFR 0.152.
 */
package gui.sim.multiple;

import automata.Automaton;
import automata.Configuration;
import automata.turing.TMConfiguration;
import automata.turing.Tape;
import automata.turing.TuringMachine;
import grammar.Grammar;
import gui.GrowableTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class InputTableModel
extends GrowableTableModel {
    private static final long serialVersionUID = 1L;
    protected static final TableModelListener LISTENER = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent event) {
            InputTableModel model = (InputTableModel)event.getSource();
            if (event.getColumn() != -1 && event.getColumn() >= model.getInputCount()) {
                return;
            }
            Integer inputs = new Integer(model.getInputCount());
            INPUTS_TO_MODELS.put(inputs, model);
        }
    };
    public boolean isMultiple = false;
    protected static final Map<Integer, InputTableModel> INPUTS_TO_MODELS = new HashMap<Integer, InputTableModel>();
    private final Map<Integer, Configuration> rowToAssociatedConfiguration = new HashMap<Integer, Configuration>();

    public InputTableModel(Automaton automaton, int add) {
        super(2 * InputTableModel.inputsForMachine(automaton) + 1 + add);
    }

    public InputTableModel(Grammar gram, int add) {
        super(3 + add);
    }

    public InputTableModel(InputTableModel model) {
        super(model);
    }

    protected InputTableModel(int columns) {
        super(columns);
    }

    @Override
    protected Object[] initializeRow(int row) {
        Object[] nr = super.initializeRow(row);
        Arrays.fill(nr, "");
        return nr;
    }

    @Override
    public String getColumnName(int column) {
        int count = this.getColumnCount();
        if (column == count - 1) {
            return "Result";
        }
        int offset = 0;
        if (this.isMultiple) {
            offset = 1;
            if (column == 0) {
                return "File";
            }
        }
        String word = "";
        if (column <= this.getInputCount() - 1 + offset && column >= offset) {
            word = "Input";
        } else if (column > this.getInputCount() - 1 + offset) {
            word = "Output";
            column -= this.getInputCount();
        }
        if (this.getInputCount() == 1) {
            return word;
        }
        return String.valueOf(word) + " " + (column + 1 - offset);
    }

    public String[][] getInputs() {
        String[][] inputs = new String[this.getRowCount() - 1][this.getInputCount()];
        int r = 0;
        while (r < inputs.length) {
            int begin = 0;
            if (this.isMultiple) {
                begin = 1;
            }
            int c = 0;
            while (c < inputs[r].length) {
                inputs[r][c] = (String)this.getValueAt(r, c + begin);
                ++c;
            }
            ++r;
        }
        return inputs;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.isMultiple) {
            return column < this.getInputCount() && column > 0;
        }
        return column < this.getInputCount();
    }

    public static int inputsForMachine(Automaton automaton) {
        return automaton instanceof TuringMachine ? ((TuringMachine)automaton).tapes() : 1;
    }

    public int getInputCount() {
        int columnCount = this.getColumnCount();
        if (this.isMultiple) {
            --columnCount;
        }
        return columnCount / 2;
    }

    public static InputTableModel getModel(Automaton automaton, boolean multipleFile) {
        InputTableModel model = INPUTS_TO_MODELS.get(new Integer(InputTableModel.inputsForMachine(automaton)));
        if (model != null && model.isMultiple == multipleFile) {
            model = new InputTableModel(model);
            int i = 0;
            while (i < model.getRowCount() - 1) {
                model.setResult(i, "", null, null, 0);
                ++i;
            }
        } else {
            int add = 0;
            if (multipleFile) {
                add = 1;
            }
            model = new InputTableModel(automaton, add);
        }
        model.addTableModelListener(LISTENER);
        if (multipleFile) {
            model.isMultiple = true;
        }
        return model;
    }

    public static InputTableModel getModel(Grammar gram, boolean multipleFile) {
        InputTableModel model = INPUTS_TO_MODELS.get(new Integer(1));
        if (model != null) {
            model = new InputTableModel(model);
            int i = 0;
            while (i < model.getRowCount() - 1) {
                model.setResult(i, "", null, null, 0);
                ++i;
            }
        } else {
            int add = 0;
            if (multipleFile) {
                add = 1;
            }
            model = new InputTableModel(gram, add);
        }
        model.addTableModelListener(LISTENER);
        if (multipleFile) {
            model.isMultiple = true;
        }
        return model;
    }

    public void setResult(int row, String result, Configuration config, ArrayList<String> comparison, int index) {
        int halfway = this.getInputCount();
        if (this.isMultiple) {
            ++halfway;
        }
        int outNum = 1;
        if (config instanceof TMConfiguration && config != null) {
            TMConfiguration c = (TMConfiguration)config;
            Tape[] tapes = c.getTapes();
            outNum = tapes.length;
            if (config.isAccept()) {
                int i = 0;
                while (i < tapes.length) {
                    String put = tapes[i].getOutput();
                    if (comparison != null) {
                        String expected = comparison.get(index + i);
                        if (!expected.equals("~") && !expected.equals(put)) {
                            put = String.valueOf(put) + "(" + expected + ")";
                        }
                        if (comparison.get(index + outNum).toLowerCase().startsWith("r")) {
                            if (!result.endsWith(")")) {
                                result = String.valueOf(result) + "(Reject)";
                            }
                            if (!put.endsWith(")")) {
                                put = String.valueOf(put) + "(" + expected + ")";
                            }
                        }
                    }
                    this.setValueAt(put, row, halfway + i);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < halfway) {
                    String put = "";
                    if (comparison != null) {
                        String expected = comparison.get(index + i);
                        if (!comparison.get(index + outNum).toLowerCase().startsWith("r")) {
                            if (!result.endsWith(")")) {
                                result = String.valueOf(result) + "(Accept)";
                            }
                            put = String.valueOf(put) + "(" + expected + ")";
                        }
                    }
                    this.setValueAt(put, row, halfway + i);
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (halfway + i < this.columns) {
                this.setValueAt("", row, halfway + i);
                ++i;
            }
            boolean accept = false;
            if (config == null) {
                if (result.equals("Reject")) {
                    accept = false;
                }
            } else {
                accept = config.isAccept();
            }
            if (comparison != null && index + outNum < comparison.size()) {
                if (comparison.get(index + outNum).toLowerCase().startsWith("r") && accept) {
                    if (!result.endsWith(")")) {
                        result = String.valueOf(result) + "(Reject)";
                    }
                } else if (!(comparison.get(index + outNum).toLowerCase().startsWith("r") || accept || result.endsWith(")"))) {
                    result = String.valueOf(result) + "(Accept)";
                }
            } else if (comparison != null) {
                // empty if block
            }
        }
        this.setValueAt(result, row, this.getColumnCount() - 1);
        if (config == null) {
            this.rowToAssociatedConfiguration.remove(new Integer(row));
        } else {
            this.rowToAssociatedConfiguration.put(new Integer(row), config);
        }
    }

    @Override
    public void clear() {
        if (this.rowToAssociatedConfiguration != null) {
            this.rowToAssociatedConfiguration.clear();
        }
        super.clear();
    }

    public Configuration getAssociatedConfigurationForRow(int row) {
        return this.rowToAssociatedConfiguration.get(new Integer(row));
    }
}

