/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;

public class Torn {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final float PADDING = 2.0f;
    private static final Color HIGHLIGHT_COLOR = new Color(255, 0, 0, 128);

    public static GeneralPath getTorn(float x, float y, float width, float height, boolean left, boolean right) {
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y);
        path.lineTo(x + width, y);
        if (right) {
            path.quadTo(x + width - height / 4.0f, y + height / 4.0f, x + width, y + height / 2.0f);
            path.quadTo(x + width - height / 4.0f, y + 3.0f * height / 4.0f, x + width, y + height);
        } else {
            path.lineTo(x + width, y + height);
        }
        path.lineTo(x, y + height);
        if (left) {
            path.quadTo(x + height / 4.0f, y + 3.0f * height / 4.0f, x, y + height / 2.0f);
            path.quadTo(x + height / 4.0f, y + height / 4.0f, x, y);
        }
        path.closePath();
        return path;
    }

    public static float paintString(Graphics2D g, String string, float x, float y, int align, float width, boolean left, boolean right, int select) {
        FontMetrics metrics = g.getFontMetrics();
        float toBaseline = 2.0f + (float)metrics.getAscent();
        float height = toBaseline + 2.0f + (float)metrics.getDescent();
        if (align == 1) {
            y -= height * 0.5f;
        }
        if (align == 2) {
            y -= height;
        }
        if (select > string.length()) {
            select = string.length();
        }
        GeneralPath torn = Torn.getTorn(x, y, width, height, left, right);
        g.setColor(Color.white);
        g.fill(torn);
        float horizontalPadding = metrics.charWidth(' ');
        Graphics2D g2 = (Graphics2D)g.create();
        g2.clip(torn);
        float dx = 0.0f;
        if (left) {
            dx = (float)metrics.getStringBounds(string, g2).getWidth() - width + 2.0f * horizontalPadding;
        }
        if (right) {
            dx *= 0.5f;
        }
        if (select >= 0 && !left && right) {
            String before = string.substring(0, select);
            String after = string.substring(select);
            double bLength = metrics.getStringBounds(before, g2).getWidth();
            double aLength = metrics.getStringBounds(after, g2).getWidth();
            float aStart = bLength > (double)(width / 2.0f) ? width / 2.0f : horizontalPadding + (float)bLength;
            float bStart = aStart - (float)bLength;
            g2.setColor(Color.gray);
            g2.drawString(before, x + bStart, y + toBaseline);
            g2.setColor(Color.black);
            g2.drawString(after, x + aStart, y + toBaseline);
        } else {
            if (select >= 0) {
                double l = metrics.getStringBounds(string.substring(0, select), g2).getWidth();
                double c = metrics.getStringBounds(string.substring(select, select + 1), g2).getWidth();
                g2.setColor(HIGHLIGHT_COLOR);
                g2.fillRect((int)((double)x + 0.5 * ((double)width - c)), (int)y, (int)c, 100);
                dx = (float)(l + 0.5 * (c - (double)width) + (double)horizontalPadding);
            }
            g2.setColor(Color.black);
            g2.drawString(string, x + horizontalPadding - dx, y + toBaseline);
        }
        g2.dispose();
        g.setColor(Color.black);
        g.draw(torn);
        return height;
    }
}

