/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import automata.State;
import gui.editor.Tool;
import gui.regular.FSAToREController;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class StateCollapseTool
extends Tool {
    private FSAToREController controller;

    public StateCollapseTool(AutomatonPane view, AutomatonDrawer drawer, FSAToREController controller) {
        super(view, drawer);
        this.controller = controller;
    }

    @Override
    public String getToolTip() {
        return "State Collapser";
    }

    @Override
    protected Icon getIcon() {
        URL url = this.getClass().getResource("/ICON/state_collapse.gif");
        return new ImageIcon(url);
    }

    @Override
    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('o');
    }

    @Override
    public void mousePressed(MouseEvent event) {
        State s = this.getDrawer().stateAtPoint(event.getPoint());
        if (s != null) {
            this.controller.stateCollapse(s);
        }
    }
}

