/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.HumanFirstPane;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import pumping.RegularPumpingLemma;

public class HumanRegPumpingLemmaInputPane
extends HumanFirstPane {
    private static final long serialVersionUID = 1L;
    private static String I_WIN = "I WIN. Do you want to play again or concede that the language is not regular?";
    private static String YOU_WIN = "YOU WIN. Does this mean the language is regular?";
    private static String PROMPT_DECOMPOSITION = "Please select the decomposition of w into xyz using the sliders.";

    public HumanRegPumpingLemmaInputPane(RegularPumpingLemma l) {
        super(l, "<i>L</i> = {" + l.getHTMLTitle() + "} Regular Pumping Lemma");
    }

    @Override
    protected void addDecompPanelGameFeatures(JPanel n) {
        n.setMaximumSize(new Dimension(HumanRegPumpingLemmaInputPane.MAX_SIZE.width, 3 * HumanRegPumpingLemmaInputPane.MAX_SIZE.height / 10));
        n.setPreferredSize(new Dimension(HumanRegPumpingLemmaInputPane.MAX_SIZE.width, 3 * HumanRegPumpingLemmaInputPane.MAX_SIZE.height / 10));
        this.decompButtonTitle = new String("Set xyz");
        n.setBorder(BorderFactory.createTitledBorder("3. Select decomposition of w into xyz."));
    }

    @Override
    protected void mEnteredReset() {
        String s = this.myLemma.getW();
        this.myWDisplay.setText(s);
        this.myXPanel.setSliderMax(s.length());
        this.myXPanel.setVal(0);
        this.myXPanel.setText(this.myLemma.getW());
        this.myYPanel.setSliderMax(s.length());
        this.myYPanel.setVal(0);
        this.myYPanel.setText(this.myLemma.getW());
        this.refresh();
        this.updateTable();
        this.leftPanel.revalidate();
    }

    @Override
    protected void resetDecompPanel() {
        this.myXPanel.reset();
        this.myYPanel.reset();
        this.myZDisplay.setText("");
        this.myZLength.setText("");
        this.updateTable();
    }

    @Override
    protected void refresh() {
        try {
            this.myXPanel.setRange(0, this.myYPanel.getVal() - 1);
            this.myYPanel.setRange(this.myXPanel.getVal(), this.myLemma.getM());
            this.myZDisplay.setText(this.myLemma.getW().substring(this.myYPanel.getVal()));
            this.myZLength.setText(Integer.toString(this.myZDisplay.getText().length()));
            this.myIDisplay.setText("");
            this.myPumpedStringDisplay.setText("");
            this.myLastWord.setText("");
            this.myCanvas.reset();
            if (this.myXPanel.getVal() >= this.myYPanel.getVal()) {
                this.myZDisplay.setText("");
                this.stageMessages[3].setText("Condition violated: |y| > 0");
                this.myZLength.setText("");
                this.myDecompButton.setEnabled(false);
            } else if (this.myYPanel.getVal() > this.myLemma.getM()) {
                this.myZDisplay.setText("");
                this.stageMessages[3].setText("Condition violated: |xy| <= m");
                this.myZLength.setText("");
                this.myDecompButton.setEnabled(false);
            } else {
                this.stageMessages[3].setText("Click \"Set xyz\" to set decomposition.");
                this.myDecompButton.setEnabled(true);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void setDecomposition(int[] decomposition) {
        this.myXPanel.setVal(decomposition[0]);
        this.myYPanel.setVal(decomposition[0] + decomposition[1]);
    }

    @Override
    protected void setI() {
        int[] d = new int[]{this.myXPanel.getVal(), this.myYPanel.getVal() - this.myXPanel.getVal()};
        this.myLemma.setDecomposition(d);
        this.myLemma.chooseI();
        if (this.myCases != null) {
            this.myCases.setDecomposition(d);
            this.myCases.setI(this.myLemma.getI());
        }
    }

    @Override
    protected void setCanvas() {
        this.stages[5].setVisible(true);
        this.myCanvas.reset();
        this.myCanvas.addText("w =");
        this.myCanvas.addText(((RegularPumpingLemma)this.myLemma).getX(), "x");
        this.myCanvas.addText(((RegularPumpingLemma)this.myLemma).getY(), "y");
        this.myCanvas.addText(((RegularPumpingLemma)this.myLemma).getZ(), "z");
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = this.myLemma.getI();
        nArray[3] = 1;
        this.myCanvas.moveText(nArray);
        this.myStepAnimation.setEnabled(true);
        this.myStartAnimation.setEnabled(false);
        this.repaint();
    }

    @Override
    protected String createXYZ() {
        return "<i>xy</i><sup>" + this.myLemma.getI() + "</sup><i>z</i>";
    }

    @Override
    public void update() {
        RegularPumpingLemma pl = (RegularPumpingLemma)this.myLemma;
        this.stageMessages[0].setText("File loaded.");
        this.updateTopPane(false);
        if (pl.getM() == -1) {
            return;
        }
        this.myMDisplay.setText("" + pl.getM());
        this.myWDisplay.setText(pl.getW());
        this.myXPanel.setText(pl.getW());
        this.myXPanel.setSliderMax(pl.getW().length());
        this.myYPanel.setText(pl.getW());
        this.myYPanel.setSliderMax(pl.getW().length());
        this.setDecomposition(new int[]{pl.getX().length(), pl.getY().length()}, pl.getI());
        this.updateTable();
        this.stages[2].setVisible(true);
        this.stages[3].setVisible(true);
        if (pl.getX().length() == 0 && pl.getY().length() == 0) {
            this.myDecompButton.setEnabled(false);
        } else {
            this.stages[4].setVisible(true);
            this.stages[5].setVisible(true);
            this.stageMessages[5].setText("Click \"Restart\" to restart the animation.");
            this.stageMessages[5].setVisible(true);
            this.displayIEnd();
            this.myCanvas.setRestartEnabled(true);
        }
    }
}

