/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.ComputerFirstPane;
import pumping.ContextFreePumpingLemma;

public class CompCFPumpingLemmaInputPane
extends ComputerFirstPane {
    private static final long serialVersionUID = 1L;

    public CompCFPumpingLemmaInputPane(ContextFreePumpingLemma l) {
        super(l, "<i>L</i> = {" + l.getHTMLTitle() + "} Context-Free Pumping Lemma");
    }

    @Override
    protected void setCanvas() {
        this.stages[5].setVisible(true);
        this.myCanvas.reset();
        this.myCanvas.addText("w =");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getU(), "u");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getV(), "v");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getX(), "x");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getY(), "y");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getZ(), "z");
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = this.myLemma.getI();
        nArray[3] = 1;
        nArray[4] = this.myLemma.getI();
        nArray[5] = 1;
        this.myCanvas.moveText(nArray);
        this.myStepAnimation.setEnabled(true);
        this.myStartAnimation.setEnabled(false);
        this.repaint();
    }

    @Override
    protected String createXYZ() {
        return "<i>uv</i><sup>" + this.myLemma.getI() + "</sup><i>xy</i><sup>" + this.myLemma.getI() + "</sup><i>z</i>";
    }

    @Override
    public void update() {
        ContextFreePumpingLemma pl = (ContextFreePumpingLemma)this.myLemma;
        this.stageMessages[0].setText("File loaded.");
        this.updateTopPane(false);
        int[] decomp = pl.getDecomposition();
        if (decomp[0] == 0 && decomp[1] == 0 && decomp[2] == 0 && decomp[3] == 0) {
            return;
        }
        this.myWDisplay.setText(pl.getW());
        int[] decomposition = new int[]{pl.getU().length(), pl.getV().length(), pl.getX().length(), pl.getY().length()};
        this.setDecomposition(decomposition, pl.getI());
        if (this.myCases != null) {
            this.myCases.setDecomposition(decomposition);
        }
        this.decompLabel.setText(this.myLemma.getDecompositionAsString());
        this.stages[3].setVisible(true);
        this.stages[4].setVisible(true);
        if (pl.getI() == -1) {
            return;
        }
        this.stages[5].setVisible(true);
        this.displayIEnd();
        this.stageMessages[5].setText("Click \"Restart\" to restart the animation.");
        this.stageMessages[5].setVisible(true);
        this.myCanvas.setRestartEnabled(true);
        if (this.myCases != null) {
            this.myCases.setAddReplaceButtonsEnabled(true);
        }
    }
}

