/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.parse.ParseNode;
import gui.grammar.parse.BruteParsePane;
import gui.grammar.parse.UnrestrictedTreeNode;
import gui.grammar.parse.UnrestrictedTreePanel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.tree.TreeNode;

public class SelectableUnrestrictedTreePanel
extends UnrestrictedTreePanel {
    private static final long serialVersionUID = 1L;
    private boolean myClicked = false;
    private Point2D myClickedNodePoint;
    private Color myColor = this.INNER;
    private static final Color CLICKED_COLOR = new Color(100, 120, 120);

    public SelectableUnrestrictedTreePanel(BruteParsePane pane) {
        super(pane);
    }

    @Override
    public TreeNode nodeAtPoint(Point2D point) {
        double x1 = point.getX();
        double y1 = point.getY();
        for (Map.Entry e : this.nodeToPoint.entrySet()) {
            Point2D tempPoint = (Point2D)e.getValue();
            double x2 = tempPoint.getX();
            double y2 = tempPoint.getY();
            if (!(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) <= Math.pow(13.0, 2.0))) continue;
            this.myClicked = true;
            this.myClickedNodePoint = new Point2D.Double(x2, y2);
            return (TreeNode)e.getKey();
        }
        return null;
    }

    public Point2D getPointofSelectedNode() {
        if (this.myClicked) {
            return this.myClickedNodePoint;
        }
        return null;
    }

    @Override
    public void setAnswer(ParseNode answer) {
        if (answer == null) {
            this.top = null;
            return;
        }
        super.setAnswer(answer);
        int i = 1;
        while (i < this.solutionParseNodes.length) {
            int j = 0;
            while (j < this.solutionParseNodes[i].getSubstitutions().length) {
                this.next();
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void paintNode(Graphics2D g, UnrestrictedTreeNode node, Point2D p) {
        g.setColor(node.lowest == this.top.length - 1 ? LEAF : this.INNER);
        if (node.getText().toUpperCase().equals(node.getText()) && !node.getText().equals("")) {
            g.setColor(this.INNER);
        }
        g.translate(p.getX(), p.getY());
        this.nodeDrawer.draw(g, node);
        g.translate(-p.getX(), -p.getY());
    }
}

