/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.parse.LRParseTable;
import gui.grammar.parse.LRParseTablePane;
import java.awt.Color;
import java.util.SortedSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class LRParseTableChooserPane
extends LRParseTablePane {
    private static final long serialVersionUID = 1L;
    private boolean finalEdit = false;
    private TableCellEditor[][] cellEditors;
    private static final DefaultTableCellRenderer RENDERER = new DefaultTableCellRenderer();

    static {
        RENDERER.setBackground(new Color(255, 200, 150));
    }

    public LRParseTableChooserPane(LRParseTable table) {
        super(table);
    }

    public void shiftMode() {
        this.finalEdit = true;
        LRParseTable table = this.getParseTable();
        this.cellEditors = new TableCellEditor[table.getRowCount()][table.getColumnCount()];
        int r = 0;
        while (r < table.getRowCount()) {
            int c = 1;
            while (c < table.getColumnCount()) {
                this.cellEditors[r][c] = null;
                SortedSet<String> set = table.getSetAt(r, c);
                if (set.size() > 1) {
                    table.setValueAt((Object)set.first(), r, c);
                    this.cellEditors[r][c] = new DefaultCellEditor(new JComboBox<Object>(set.toArray()));
                }
                ++c;
            }
            ++r;
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (!this.finalEdit) {
            return super.isCellEditable(row, column);
        }
        return this.cellEditors[row][column = this.convertColumnIndexToModel(column)] != null;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (!this.finalEdit) {
            return super.getCellRenderer(row, column);
        }
        int mc = this.convertColumnIndexToModel(column);
        return this.cellEditors[row][mc] == null ? super.getCellRenderer(row, column) : RENDERER;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (!this.finalEdit) {
            return super.getCellEditor(row, column);
        }
        int mc = this.convertColumnIndexToModel(column);
        return this.cellEditors[row][mc] == null ? super.getCellEditor(row, column) : this.cellEditors[row][mc];
    }
}

