/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.Operations;
import gui.SuperMouseAdapter;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.grammar.ImmutableGrammarTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class ItemSetChooser {
    private final GrammarTableListener GTListener = new GrammarTableListener();
    private Component parent;
    private JPanel panel = new JPanel(new BorderLayout());
    private GrammarTable chooseTable;
    private GrammarTable choiceTable;
    private Set<Production> restricted = null;
    private Set<Production> alreadyChosen;
    private Grammar grammar;

    public ItemSetChooser(Grammar grammar, Component parent) {
        this.grammar = grammar;
        this.parent = parent;
        this.chooseTable = new GrammarTable(new ImmutableGrammarTableModel(grammar));
        this.chooseTable.addMouseListener(this.GTListener);
        this.choiceTable = new GrammarTable(new ImmutableGrammarTableModel());
        JScrollPane p = new JScrollPane(this.chooseTable);
        p.setPreferredSize(new Dimension(200, 200));
        this.panel.add((Component)p, "West");
        p = new JScrollPane(this.choiceTable);
        p.setPreferredSize(new Dimension(200, 200));
        this.panel.add((Component)p, "East");
        JToolBar bar = new JToolBar();
        bar.add(new AbstractAction("Closure"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemSetChooser.this.closure();
            }
        });
        bar.add(new AbstractAction("Finish"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemSetChooser.this.finish();
            }
        });
        this.panel.add((Component)bar, "North");
    }

    private void closure() {
        HashSet<Production> selected = new HashSet<Production>();
        GrammarTableModel model = this.choiceTable.getGrammarModel();
        int i = 0;
        while (i < model.getRowCount() - 1) {
            if (this.choiceTable.isRowSelected(i)) {
                selected.add(model.getProduction(i));
            }
            ++i;
        }
        if (selected.size() == 0) {
            JOptionPane.showMessageDialog(this.parent, "Select an item (or items) in the right table.", "Nothing Selected", 0);
            return;
        }
        Set<Production> closureSet = Operations.closure(this.grammar, selected);
        closureSet.removeAll(this.alreadyChosen);
        Iterator<Production> it = closureSet.iterator();
        while (it.hasNext()) {
            this.addItem(it.next());
        }
    }

    private void finish() {
        if (this.restricted == null) {
            JOptionPane.showMessageDialog(this.parent, "There is no one right answer in this case.", "Ambiguity", 0);
            return;
        }
        HashSet<Production> toAdd = new HashSet<Production>(this.restricted);
        toAdd.removeAll(this.alreadyChosen);
        Iterator<Production> it = toAdd.iterator();
        while (it.hasNext()) {
            this.addItem(it.next());
        }
    }

    public Production[] getItemSet(Set<Production> items, String message) {
        ArrayList<Production> selected;
        this.restricted = items;
        this.choiceTable.setModel(new ImmutableGrammarTableModel());
        this.alreadyChosen = new HashSet<Production>();
        while (true) {
            HashSet selectedSet;
            int choice;
            if ((choice = JOptionPane.showConfirmDialog(this.parent, this.panel, message, 2)) == 2) {
                return null;
            }
            selected = new ArrayList<Production>();
            GrammarTableModel model = this.choiceTable.getGrammarModel();
            int i = 0;
            while (i < model.getRowCount() - 1) {
                selected.add(model.getProduction(i));
                ++i;
            }
            if (items == null || (selectedSet = new HashSet(selected)).equals(items)) break;
            JOptionPane.showMessageDialog(this.parent, "Some items are missing!", "Items Missing", 0);
        }
        return selected.toArray(new Production[0]);
    }

    private void addItem(Production item) {
        if (this.restricted != null && !this.restricted.contains(item)) {
            JOptionPane.showMessageDialog(this.parent, String.valueOf(item.toString()) + " is not part of the set.", "Item not Desirable", 0);
            return;
        }
        if (this.alreadyChosen.contains(item)) {
            JOptionPane.showMessageDialog(this.parent, String.valueOf(item.toString()) + " is already chosen.", "Item Already Chosen", 0);
            return;
        }
        this.alreadyChosen.add(item);
        this.choiceTable.getGrammarModel().addProduction(item);
    }

    private class GrammarTableListener
    extends SuperMouseAdapter {
        private GrammarTableListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Point at;
            GrammarTable gt = (GrammarTable)event.getSource();
            int row = gt.rowAtPoint(at = event.getPoint());
            if (row == -1) {
                return;
            }
            if (row == gt.getGrammarModel().getRowCount() - 1) {
                return;
            }
            Production p = gt.getGrammarModel().getProduction(row);
            Production[] pItems = Operations.getItems(p);
            JPopupMenu menu = new JPopupMenu();
            ItemMenuListener itemListener = new ItemMenuListener(p);
            int i = 0;
            while (i < pItems.length) {
                JMenuItem item = new JMenuItem(pItems[i].toString());
                item.setActionCommand(pItems[i].getRHS());
                item.addActionListener(itemListener);
                menu.add(item);
                ++i;
            }
            menu.show(gt, at.x, at.y);
        }
    }

    private class ItemMenuListener
    implements ActionListener {
        Production prod;

        public ItemMenuListener(Production p) {
            this.prod = p;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String rhs = event.getActionCommand();
            Production p = new Production(this.prod.getLHS(), rhs);
            ItemSetChooser.this.addItem(p);
        }
    }
}

