/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar;

import debug.EDebug;
import grammar.Grammar;
import grammar.Production;
import gui.HighlightTable;
import gui.TableTextSizeSlider;
import gui.environment.Universe;
import gui.grammar.GrammarTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class GrammarTable
extends HighlightTable {
    private static final long serialVersionUID = 1L;
    private static final HighlightTable.TableHighlighterRendererGenerator THRG = new HighlightTable.TableHighlighterRendererGenerator(){
        private DefaultTableCellRenderer renderer = null;

        @Override
        public TableCellRenderer getRenderer(int row, int column) {
            if (this.renderer == null) {
                this.renderer = new LambdaCellRenderer();
                this.renderer.setBackground(new Color(255, 150, 150));
            }
            return this.renderer;
        }
    };
    private static final TableCellRenderer RENDERER = new LambdaCellRenderer();

    public GrammarTable() {
        super(new GrammarTableModel());
        this.initView();
    }

    public GrammarTable(GrammarTableModel model) {
        super(model);
        this.initView();
    }

    public void highlight(int row) {
        this.highlight(row, 0);
        this.highlight(row, 2);
    }

    private void initView() {
        this.setTableHeader(new JTableHeader(this.getColumnModel()));
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        TableColumn lhs = this.getColumnModel().getColumn(0);
        TableColumn arrows = this.getColumnModel().getColumn(1);
        TableColumn rhs = this.getColumnModel().getColumn(2);
        lhs.setHeaderValue("LHS");
        this.getTableHeader().resizeAndRepaint();
        rhs.setHeaderValue("RHS");
        this.getTableHeader().resizeAndRepaint();
        this.getColumnModel().getColumn(0).setPreferredWidth(70);
        lhs.setMaxWidth(200);
        arrows.setMaxWidth(30);
        arrows.setMinWidth(30);
        this.getColumnModel().getColumn(1).setPreferredWidth(30);
        this.setShowGrid(true);
        this.setGridColor(Color.lightGray);
        this.rowHeight = 30;
        this.setFont(new Font("TimesRoman", 0, 20));
        this.getColumnModel().getColumn(2).setCellRenderer(RENDERER);
        this.add((Component)new TableTextSizeSlider(this, 0), "North");
    }

    public GrammarTableModel getGrammarModel() {
        return (GrammarTableModel)super.getModel();
    }

    public Grammar getGrammar(Class<?> grammarClass) {
        Grammar grammar = null;
        try {
            grammar = (Grammar)grammarClass.newInstance();
        }
        catch (NullPointerException e) {
            EDebug.print("Throwing a Null Pointer Back at YOU.");
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Bad grammar class " + grammarClass);
        }
        GrammarTableModel model = this.getGrammarModel();
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
        int row = 0;
        while (row < model.getRowCount()) {
            Production p = model.getProduction(row);
            if (p != null) {
                try {
                    grammar.addProduction(p);
                    if (grammar.getStartVariable() == null) {
                        grammar.setStartVariable(p.getLHS());
                    }
                }
                catch (IllegalArgumentException e) {
                    this.setRowSelectionInterval(row, row);
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Production Error", 0);
                    return null;
                }
            }
            ++row;
        }
        return grammar;
    }

    @Override
    public void highlight(int row, int column) {
        this.highlight(row, column, THRG);
    }

    private static class LambdaCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private LambdaCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel l = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (hasFocus && table.isCellEditable(row, column)) {
                return l;
            }
            if (column != 2) {
                return l;
            }
            if (!value.equals("")) {
                return l;
            }
            if (table.getModel().getValueAt(row, 0).equals("")) {
                return l;
            }
            l.setText(Universe.curProfile.getEmptyString());
            return l;
        }
    }
}

