/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.fsa.FiniteStateAutomaton;
import automata.mealy.MealyMachine;
import automata.mealy.MooreMachine;
import automata.pda.PushdownAutomaton;
import automata.turing.TuringMachine;
import automata.vdg.VariableDependencyGraph;
import gui.editor.FSATransitionCreator;
import gui.editor.MealyTransitionCreator;
import gui.editor.MooreTransitionCreator;
import gui.editor.PDATransitionCreator;
import gui.editor.TMTransitionCreator;
import gui.editor.VDGTransitionCreator;
import gui.viewer.AutomatonPane;
import java.awt.Point;
import javax.swing.JOptionPane;

public abstract class TransitionCreator {
    private AutomatonPane parent = null;

    public TransitionCreator() {
    }

    public TransitionCreator(AutomatonPane parent) {
        this.parent = parent;
    }

    protected Automaton getAutomaton() {
        return this.getParent().getDrawer().getAutomaton();
    }

    public abstract Transition createTransition(State var1, State var2);

    public abstract boolean editTransition(Transition var1);

    public static TransitionCreator creatorForAutomaton(Automaton automaton, AutomatonPane parent) {
        if (automaton instanceof FiniteStateAutomaton) {
            return new FSATransitionCreator(parent);
        }
        if (automaton instanceof PushdownAutomaton) {
            return new PDATransitionCreator(parent);
        }
        if (automaton instanceof TuringMachine) {
            return new TMTransitionCreator(parent);
        }
        if (automaton instanceof VariableDependencyGraph) {
            return new VDGTransitionCreator(parent);
        }
        if (automaton instanceof MooreMachine) {
            return new MooreTransitionCreator(parent);
        }
        if (automaton instanceof MealyMachine) {
            return new MealyTransitionCreator(parent);
        }
        return null;
    }

    public void editTransition(Transition transition, Point point) {
        this.editTransition(transition);
    }

    public AutomatonPane getParent() {
        return this.parent;
    }

    public void reportException(IllegalArgumentException e) {
        JOptionPane.showMessageDialog(this.getParent(), "Bad format!\n" + e.getMessage(), "Bad Format", 0);
    }
}

