/*
 * Decompiled with CFR 0.152.
 */
package gui.deterministic;

import automata.fsa.FiniteStateAutomaton;
import gui.deterministic.AddTrapStateController;
import gui.deterministic.TrapStateTool;
import gui.deterministic.TrapTransitionTool;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBar;
import gui.editor.ToolBox;
import gui.environment.AutomatonEnvironment;
import gui.environment.EnvironmentFrame;
import gui.environment.Universe;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AddTrapStatePane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private AutomatonEnvironment myEnvironment;
    private FiniteStateAutomaton myAutomaton;

    public AddTrapStatePane(AutomatonEnvironment environment) {
        this.myAutomaton = (FiniteStateAutomaton)environment.getAutomaton().clone();
        EnvironmentFrame frame = Universe.frameForEnvironment(environment);
        this.setLayout(new BorderLayout());
        JPanel labels = new JPanel(new BorderLayout());
        JLabel mainLabel = new JLabel();
        JLabel detailLabel = new JLabel();
        labels.add((Component)mainLabel, "North");
        labels.add((Component)detailLabel, "South");
        this.add((Component)labels, "North");
        SelectionDrawer automatonDrawer = new SelectionDrawer(this.myAutomaton);
        final AddTrapStateController controller = new AddTrapStateController(this.myAutomaton, automatonDrawer, mainLabel, detailLabel, frame);
        EditorPane ep = new EditorPane(automatonDrawer, new ToolBox(){

            @Override
            public List<Tool> tools(AutomatonPane view, AutomatonDrawer drawer) {
                LinkedList<Tool> tools = new LinkedList<Tool>();
                tools.add(new ArrowNontransitionTool(view, drawer));
                tools.add(new TrapStateTool(view, drawer, controller));
                tools.add(new TrapTransitionTool(view, drawer, controller));
                return tools;
            }
        });
        ToolBar bar = ep.getToolBar();
        bar.addSeparator();
        bar.add(new JButton(new AbstractAction("Do All"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.doAll();
            }
        }));
        this.add((Component)ep, "Center");
    }
}

