/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import grammar.Grammar;
import grammar.Production;
import grammar.UnrestrictedGrammar;
import gui.action.GrammarAction;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.parse.TMBruteParsePane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;

public class TuringBruteParseAction
extends GrammarAction {
    private static final long serialVersionUID = 1L;
    private GrammarEnvironment environment;
    private EnvironmentFrame frame;
    private HashMap<String, String> myVariableMap;

    public TuringBruteParseAction(GrammarEnvironment environment) {
        super("Parser for Converted Grammar from TM", null);
        this.environment = environment;
        this.frame = Universe.frameForEnvironment(environment);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Grammar g = this.environment.getGrammar(UnrestrictedGrammar.class);
        Production[] p = g.getProductions();
        Grammar g_trimmed = this.trim(p);
        if (g == null) {
            return;
        }
        TMBruteParsePane bpp = new TMBruteParsePane(this.environment, g, g_trimmed, this.myVariableMap, null);
        this.environment.add((Component)bpp, "Parser for Converted Grammar from TM", new CriticalTag(){});
        this.environment.setActive(bpp);
    }

    private Grammar trim(Production[] prods) {
        this.myVariableMap = new HashMap();
        char ch = 'A';
        int i = 0;
        while (i < prods.length) {
            String lhs = prods[i].getLHS();
            if (ch == 'S' || ch == 'T') {
                ch = (char)(ch + 1);
            }
            int aa = lhs.indexOf("V(");
            while (aa > -1) {
                int bb = lhs.indexOf(")");
                String var = "";
                if (aa + bb + 1 > lhs.length()) {
                    var = lhs.substring(aa, aa + bb);
                    lhs = String.valueOf(lhs.substring(0, aa)) + ch;
                } else {
                    var = lhs.substring(aa, aa + bb + 1);
                    lhs = String.valueOf(lhs.substring(0, aa)) + ch + lhs.substring(aa + bb);
                }
                aa = lhs.indexOf("V(");
                this.myVariableMap.put("" + ch, var);
                int k = 0;
                while (k < prods.length) {
                    String inner_lhs = prods[k].getLHS();
                    String inner_rhs = prods[k].getRHS();
                    int a = inner_lhs.indexOf(var);
                    if (a > -1) {
                        inner_lhs = String.valueOf(inner_lhs.substring(0, a)) + ch + inner_lhs.substring(a + var.length());
                    }
                    if ((a = inner_rhs.indexOf(var)) > -1) {
                        inner_rhs = String.valueOf(inner_rhs.substring(0, a)) + ch + inner_rhs.substring(a + var.length());
                    }
                    prods[k] = new Production(inner_lhs, inner_rhs);
                    ++k;
                }
                ch = (char)(ch + '\u0001');
            }
            ++i;
        }
        UnrestrictedGrammar g = new UnrestrictedGrammar();
        g.addProductions(prods);
        return g;
    }
}

