/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.NondeterminismDetector;
import automata.NondeterminismDetectorFactory;
import automata.SimulatorFactory;
import automata.State;
import automata.graph.AutomatonDirectedGraph;
import automata.mealy.MealyMachine;
import automata.turing.NDTMSimulator;
import automata.turing.TMSimulator;
import automata.turing.TuringMachine;
import grammar.Grammar;
import gui.action.AutomatonAction;
import gui.action.SimulateNoClosureAction;
import gui.editor.EditBlockPane;
import gui.environment.Environment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.sim.SimulatorPane;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class SimulateAction
extends AutomatonAction {
    private static final long serialVersionUID = 1L;
    private Grammar gram;
    private Automaton automaton;
    private Environment environment;

    public SimulateAction(Automaton automaton, Environment environment) {
        super("Step...", null);
        if (SimulateNoClosureAction.isApplicable(automaton)) {
            this.putValue("Name", "Step with Closure...");
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, MAIN_MENU_MASK));
        this.automaton = automaton;
        this.environment = environment;
    }

    public SimulateAction(Grammar gram, Environment environment) {
        super("Step...", null);
        if (SimulateNoClosureAction.isApplicable(this.automaton)) {
            this.putValue("Name", "Step with Closure...");
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, MAIN_MENU_MASK));
        this.gram = gram;
        this.environment = environment;
    }

    protected AutomatonSimulator getSimulator(Automaton automaton) {
        return SimulatorFactory.getSimulator(automaton);
    }

    public void handleInteraction(Automaton automaton, AutomatonSimulator simulator, Configuration[] configurations, Object initialInput) {
        SimulatorPane simpane = new SimulatorPane(automaton, simulator, configurations, this.environment, false);
        if (initialInput instanceof String[]) {
            initialInput = Arrays.asList((String[])initialInput);
        }
        this.environment.add((Component)simpane, "Simulate: " + initialInput, new CriticalTag(){});
        this.environment.setActive(simpane);
    }

    protected Object initialInput(Component component, String title) {
        if (title.equals("")) {
            title = "Input";
        }
        if (this.getObject() instanceof TuringMachine) {
            TuringMachine tm = (TuringMachine)this.getObject();
            int tapes = tm.tapes();
            if (title.equals("Expected Result? (Accept or Reject)")) {
                title = "Result";
                tapes = 1;
            }
            if (title.equals("Expected Output?")) {
                title = "Output";
            }
            return this.openInputGUI(component, title, tapes);
        }
        if (title.equals("")) {
            return this.openInputGUI(component, "Input?", 0);
        }
        return this.openInputGUI(component, title, 0);
    }

    private Object openInputGUI(final Component component, String title, final int tapes) {
        int i;
        JTextField[] fields;
        JPanel panel;
        if (tapes == 0) {
            panel = new JPanel(new GridLayout(3, 1));
            fields = new JTextField[1];
            i = 0;
            while (i < 1) {
                panel.add(new JLabel(String.valueOf(title) + " "));
                fields[i] = new JTextField();
                panel.add(fields[i]);
                ++i;
            }
        } else {
            panel = new JPanel(new GridLayout(tapes * 2 + 1, 2));
            fields = new JTextField[tapes];
            i = 0;
            while (i < tapes) {
                panel.add(new JLabel(String.valueOf(title) + " " + (i + 1)));
                fields[i] = new JTextField();
                panel.add(fields[i]);
                ++i;
            }
        }
        JButton jb = new JButton("Click to Open Input File");
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser ourChooser = new JFileChooser(System.getProperties().getProperty("user.dir"));
                int retval = ourChooser.showOpenDialog(null);
                File f = null;
                if (retval == 0) {
                    f = ourChooser.getSelectedFile();
                    try {
                        Scanner sc = new Scanner(f);
                        if (tapes != 0) {
                            String[] input = new String[tapes];
                            int i = 0;
                            while (i < tapes) {
                                if (!sc.hasNext()) {
                                    JOptionPane.showMessageDialog(component, "Input file does not have enough input for all tapes", "File read error", 0);
                                    sc.close();
                                    return;
                                }
                                input[i] = sc.next();
                                ++i;
                            }
                            JOptionPane.getFrameForComponent(component).dispose();
                            SimulateAction.this.handleInputFile(input);
                        } else {
                            String tt = sc.next();
                            JOptionPane.getFrameForComponent(component).dispose();
                            SimulateAction.this.handleInputFile(tt);
                        }
                        sc.close();
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        panel.add(jb);
        int result = JOptionPane.showOptionDialog(component, panel, title, 2, 3, null, null, null);
        if (result != 0 && result != 0) {
            return null;
        }
        if (tapes == 0) {
            String input = fields[0].getText();
            return input;
        }
        String[] input = new String[tapes];
        int i2 = 0;
        while (i2 < tapes) {
            input[i2] = fields[i2].getText();
            ++i2;
        }
        return input;
    }

    private void handleInputFile(Object input) {
        Configuration[] configs = null;
        AutomatonSimulator simulator = this.getSimulator(this.automaton);
        if (input == null) {
            return;
        }
        if (this.getObject() instanceof TuringMachine) {
            String[] s = (String[])input;
            configs = ((TMSimulator)simulator).getInitialConfigurations(s);
        } else {
            String s = (String)input;
            configs = simulator.getInitialConfigurations(s);
        }
        this.handleInteraction(this.automaton, simulator, configs, input);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean blockEdit = false;
        if (this.environment.getActive() instanceof EditBlockPane) {
            EditBlockPane newPane = (EditBlockPane)this.environment.getActive();
            this.automaton = newPane.getAutomaton();
            blockEdit = true;
        }
        if (!this.automatonActionPermissible((Component)e.getSource())) {
            return;
        }
        Object input = this.initialInput((Component)e.getSource(), "");
        Configuration[] configs = null;
        AutomatonSimulator simulator = this.getSimulator(this.automaton);
        if (input == null) {
            return;
        }
        if (this.getObject() instanceof TuringMachine) {
            String[] s = (String[])input;
            NondeterminismDetector d = NondeterminismDetectorFactory.getDetector(this.automaton);
            State[] nd = d.getNondeterministicStates(this.automaton);
            configs = nd.length > 0 ? ((NDTMSimulator)simulator).getInitialConfigurations(s) : ((TMSimulator)simulator).getInitialConfigurations(s);
        } else {
            String s = (String)input;
            configs = simulator.getInitialConfigurations(s);
        }
        this.handleInteraction(this.automaton, simulator, configs, input);
    }

    protected boolean automatonActionPermissible(Component source) {
        if (!(this.getObject() instanceof Automaton)) {
            return true;
        }
        if (this.automaton.getInitialState() == null) {
            JOptionPane.showMessageDialog(source, "Simulation requires an automaton\nwith an initial state!", "No Initial State", 0);
            return false;
        }
        if (this.automaton instanceof MealyMachine) {
            NondeterminismDetector d = NondeterminismDetectorFactory.getDetector(this.automaton);
            State[] nd = d.getNondeterministicStates(this.automaton);
            if (nd.length > 0) {
                JOptionPane.showMessageDialog(source, "Please remove nondeterminism for simulation.\nSelect menu item Test : Highlight Nondeterminism\nto see nondeterministic states.", "Nondeterministic states detected", 0);
                return false;
            }
        } else if (this.automaton instanceof TuringMachine && !Universe.curProfile.transitionsFromTuringFinalStateAllowed()) {
            TuringMachine turingMachine = (TuringMachine)this.automaton;
            State[] finalStates = turingMachine.getFinalStates();
            AutomatonDirectedGraph graph = new AutomatonDirectedGraph(turingMachine);
            int i = 0;
            while (i < finalStates.length) {
                if (graph.fromDegree(finalStates[i], false) > 0) {
                    JOptionPane.showMessageDialog(source, "There are transitions from final states.  Please remove them or change \nthe preference in the \"Preferences\" menu in the JFLAP main menu.", "Transitions From Final States", 0);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean isApplicable(Object object) {
        return object instanceof Automaton;
    }

    protected Object getObject() {
        if (this.automaton != null) {
            return this.automaton;
        }
        return this.gram;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    protected void setEnvironment(Environment newEnv) {
        this.environment = newEnv;
    }
}

