/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.NondeterminismDetector;
import automata.NondeterminismDetectorFactory;
import automata.SimulatorFactory;
import automata.State;
import automata.mealy.MealyConfiguration;
import automata.mealy.MealyMachine;
import automata.turing.NDTMSimulator;
import automata.turing.TMSimulator;
import automata.turing.TuringMachine;
import grammar.Grammar;
import gui.JTableExtender;
import gui.SplitPaneFactory;
import gui.TableTextSizeSlider;
import gui.action.NoInteractionSimulateAction;
import gui.action.TestAction;
import gui.editor.ArrowDisplayOnlyTool;
import gui.editor.EditorPane;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.Profile;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.GrammarInputPane;
import gui.grammar.parse.BruteParsePane;
import gui.sim.TraceWindow;
import gui.sim.multiple.InputTableModel;
import gui.viewer.AutomatonPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class MultipleSimulateAction
extends NoInteractionSimulateAction {
    private static final long serialVersionUID = 1L;
    protected JTable table = null;
    private static String[] RESULT = new String[]{"Accept", "Reject", "Cancelled"};
    protected JPanel myPanel = null;
    private static Color[] RESULT_COLOR = new Color[]{Color.green, Color.red, Color.black};

    public MultipleSimulateAction(Automaton automaton, Environment environment) {
        super(automaton, environment);
        this.putValue("Name", "Multiple Run");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, MAIN_MENU_MASK));
    }

    public MultipleSimulateAction(Grammar gram, Environment environment) {
        super(gram, environment);
        this.putValue("Name", "Multiple Run");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, MAIN_MENU_MASK));
    }

    public String getComponentTitle() {
        return "Multiple Run";
    }

    /*
     * Unable to fully structure code
     */
    protected int handleInput(Automaton automaton, AutomatonSimulator simulator, Configuration[] configs, Object initialInput, List<Configuration> associatedConfigurations) {
        frame = Universe.frameForEnvironment(this.getEnvironment());
        numberGenerated = 0;
        warningGenerated = 500;
        lastConsidered = configs[configs.length - 1];
        while (configs.length > 0) {
            block4: {
                if ((numberGenerated += configs.length) < warningGenerated) break block4;
                if (this.confirmContinue(numberGenerated, frame)) ** GOTO lbl12
                associatedConfigurations.add(lastConsidered);
                return 2;
lbl-1000:
                // 1 sources

                {
                    warningGenerated *= 2;
lbl12:
                    // 2 sources

                    ** while (numberGenerated >= warningGenerated)
                }
            }
            next = new ArrayList<Configuration>();
            i = 0;
            while (i < configs.length) {
                lastConsidered = configs[i];
                if (configs[i].isAccept()) {
                    associatedConfigurations.add(configs[i]);
                    return 0;
                }
                next.addAll(simulator.stepConfiguration(configs[i]));
                ++i;
            }
            configs = next.toArray(new Configuration[0]);
        }
        associatedConfigurations.add(lastConsidered);
        return 1;
    }

    protected JTableExtender initializeTable(Object obj) {
        boolean multiple = false;
        int inputCount = 0;
        if (this.getEnvironment().myObjects != null) {
            multiple = true;
            inputCount = 1;
        }
        InputTableModel model = null;
        if (this.getObject() instanceof Automaton) {
            model = InputTableModel.getModel((Automaton)this.getObject(), multiple);
        } else if (this.getObject() instanceof Grammar) {
            model = InputTableModel.getModel((Grammar)this.getObject(), multiple);
        }
        JTableExtender table = new JTableExtender((TableModel)model, this);
        TableColumnModel tcmodel = table.getColumnModel();
        inputCount += model.getInputCount();
        int i = model.getInputCount();
        while (i > 0) {
            tcmodel.removeColumn(tcmodel.getColumn(inputCount));
            --i;
        }
        if (multiple) {
            ArrayList<Object> autos = this.getEnvironment().myObjects;
            ArrayList<String> strings = this.getEnvironment().myTestStrings;
            int offset = strings.size();
            int row = 0;
            int m = 0;
            while (m < autos.size()) {
                int k = 0;
                while (k < strings.size()) {
                    row = k + offset * m;
                    Object currentObj = autos.get(m);
                    if (currentObj instanceof Automaton) {
                        model.setValueAt(((Automaton)currentObj).getFileName(), row, 0);
                        model.setValueAt(strings.get(k), row, 1);
                    } else if (currentObj instanceof Grammar) {
                        model.setValueAt(((Grammar)currentObj).getFileName(), row, 0);
                        model.setValueAt(strings.get(k), row, 1);
                    }
                    ++k;
                }
                ++m;
            }
            while (model.getRowCount() - 1 > autos.size() * strings.size()) {
                model.deleteRow(model.getRowCount() - 2);
            }
        }
        table.setShowGrid(true);
        table.setGridColor(Color.lightGray);
        return table;
    }

    public void performAction(Component source) {
        Automaton a;
        NondeterminismDetector d;
        State[] nd;
        if (this.getObject() instanceof Automaton && ((Automaton)this.getObject()).getInitialState() == null) {
            JOptionPane.showMessageDialog(source, "Simulation requires an automaton\nwith an initial state!", "No Initial State", 0);
            return;
        }
        if (this.getObject() instanceof MealyMachine && (nd = (d = NondeterminismDetectorFactory.getDetector(a = (Automaton)this.getObject())).getNondeterministicStates(a)).length > 0) {
            JOptionPane.showMessageDialog(source, "Please remove nondeterminism for simulation.\nSelect menu item Test : Highlight Nondeterminism\nto see nondeterministic states.", "Nondeterministic states detected", 0);
            return;
        }
        this.table = this.initializeTable(this.getObject());
        if (((InputTableModel)this.table.getModel()).isMultiple) {
            this.getEnvironment().remove(this.getEnvironment().getActive());
        }
        JPanel panel = new JPanel(new BorderLayout());
        JToolBar bar = new JToolBar();
        if (this.getEnvironment().getObject() instanceof Automaton) {
            JScrollPane scrollPane = new JScrollPane(this.table);
            scrollPane.add((Component)bar, "LOWER_LEFT_CORNER");
            panel.add((Component)scrollPane, "Center");
            panel.add((Component)new TableTextSizeSlider(this.table, 0), "North");
            bar.add(Box.createHorizontalGlue());
        } else {
            panel.add((Component)new JScrollPane(this.table), "Center");
            panel.add((Component)bar, "South");
            panel.add((Component)new TableTextSizeSlider(this.table, 0), "North");
        }
        bar.add(new AbstractAction("Load Inputs"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MultipleSimulateAction.this.table.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                InputTableModel model = (InputTableModel)MultipleSimulateAction.this.table.getModel();
                JFileChooser ourChooser = new JFileChooser(System.getProperties().getProperty("user.dir"));
                int retval = ourChooser.showOpenDialog(null);
                File f = null;
                if (retval == 0) {
                    f = ourChooser.getSelectedFile();
                    try {
                        Scanner sc = new Scanner(f);
                        int last = model.getRowCount() - 1;
                        while (sc.hasNext()) {
                            String temp = sc.next();
                            model.setValueAt(temp, last, 0);
                            ++last;
                        }
                        sc.close();
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        bar.add(new AbstractAction("Run Inputs"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MultipleSimulateAction.this.table.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                InputTableModel model = (InputTableModel)MultipleSimulateAction.this.table.getModel();
                if (MultipleSimulateAction.this.getObject() instanceof Automaton) {
                    Automaton currentAuto = (Automaton)MultipleSimulateAction.this.getObject();
                    AutomatonSimulator simulator = SimulatorFactory.getSimulator(currentAuto);
                    String[][] inputs = model.getInputs();
                    int uniqueInputs = inputs.length;
                    int tapes = 1;
                    if (model.isMultiple) {
                        if (currentAuto instanceof TuringMachine) {
                            tapes = ((TuringMachine)currentAuto).tapes;
                        }
                        uniqueInputs = MultipleSimulateAction.this.getEnvironment().myTestStrings.size() / tapes;
                    }
                    int r = 0;
                    while (r < inputs.length) {
                        if (r > 0 && r % uniqueInputs == 0) {
                            currentAuto = (Automaton)MultipleSimulateAction.this.getEnvironment().myObjects.get(r / uniqueInputs);
                            simulator = SimulatorFactory.getSimulator(currentAuto);
                        }
                        Configuration[] configs = null;
                        String[] input = null;
                        if (currentAuto instanceof TuringMachine) {
                            Automaton a = (Automaton)MultipleSimulateAction.this.getObject();
                            NondeterminismDetector d = NondeterminismDetectorFactory.getDetector(a);
                            State[] nd = d.getNondeterministicStates(a);
                            if (nd.length > 0) {
                                configs = ((NDTMSimulator)simulator).getInitialConfigurations(inputs[r]);
                                input = inputs[r];
                            } else {
                                configs = ((TMSimulator)simulator).getInitialConfigurations(inputs[r]);
                                input = inputs[r];
                            }
                        } else {
                            configs = simulator.getInitialConfigurations(inputs[r][0]);
                            input = inputs[r][0];
                        }
                        ArrayList<Configuration> associated = new ArrayList<Configuration>();
                        int result = MultipleSimulateAction.this.handleInput(currentAuto, simulator, configs, input, associated);
                        Configuration c = null;
                        if (associated.size() != 0) {
                            c = (Configuration)associated.get(0);
                        }
                        if (MultipleSimulateAction.this.getObject() instanceof MealyMachine) {
                            MealyConfiguration con = (MealyConfiguration)c;
                            model.setResult(r, con.getOutput(), con, MultipleSimulateAction.this.getEnvironment().myTransducerStrings, r % uniqueInputs * (tapes + 1));
                        } else {
                            model.setResult(r, RESULT[result], c, MultipleSimulateAction.this.getEnvironment().myTransducerStrings, r % uniqueInputs * (tapes + 1));
                        }
                        ++r;
                    }
                } else if (MultipleSimulateAction.this.getObject() instanceof Grammar) {
                    String[][] inputs = model.getInputs();
                    int uniqueInputs = inputs.length;
                    Grammar currentGram = (Grammar)MultipleSimulateAction.this.getObject();
                    BruteParsePane parsePane = new BruteParsePane((GrammarEnvironment)MultipleSimulateAction.this.getEnvironment(), currentGram, model);
                    parsePane.inputField.setEditable(false);
                    parsePane.row = -1;
                    parsePane.parseMultiple();
                }
            }
        });
        if (!((InputTableModel)this.table.getModel()).isMultiple) {
            bar.add(new AbstractAction("Clear"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MultipleSimulateAction.this.table.getCellEditor().stopCellEditing();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    InputTableModel model = (InputTableModel)MultipleSimulateAction.this.table.getModel();
                    model.clear();
                }
            });
            String empty = "Lambda";
            if (Universe.curProfile.getEmptyString().equals(Profile.LAMBDA)) {
                empty = "Lambda";
            } else if (Universe.curProfile.getEmptyString().equals(Profile.EPSILON)) {
                empty = "Epsilon";
            }
            bar.add(new AbstractAction("Enter " + empty){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = MultipleSimulateAction.this.table.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    int column = 0;
                    while (column < MultipleSimulateAction.this.table.getColumnCount() - 1) {
                        MultipleSimulateAction.this.table.getModel().setValueAt("", row, column);
                        ++column;
                    }
                }
            });
        }
        if (this.getObject() instanceof Automaton) {
            bar.add(new AbstractAction("View Trace"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] rows = MultipleSimulateAction.this.table.getSelectedRows();
                    InputTableModel tm = (InputTableModel)MultipleSimulateAction.this.table.getModel();
                    ArrayList<Integer> nonassociatedRows = new ArrayList<Integer>();
                    int i = 0;
                    while (i < rows.length) {
                        if (rows[i] != tm.getRowCount() - 1) {
                            Configuration c = tm.getAssociatedConfigurationForRow(rows[i]);
                            if (c == null) {
                                nonassociatedRows.add(new Integer(rows[i] + 1));
                            } else {
                                TraceWindow window = new TraceWindow(c);
                                window.setVisible(true);
                                window.toFront();
                            }
                        }
                        ++i;
                    }
                    if (nonassociatedRows.size() > 0) {
                        StringBuffer sb = new StringBuffer("Row");
                        if (nonassociatedRows.size() > 1) {
                            sb.append("s");
                        }
                        sb.append(" ");
                        sb.append(nonassociatedRows.get(0));
                        int i2 = 1;
                        while (i2 < nonassociatedRows.size()) {
                            if (i2 == nonassociatedRows.size() - 1) {
                                sb.append(" and ");
                            } else {
                                sb.append(", ");
                            }
                            sb.append(nonassociatedRows.get(i2));
                            ++i2;
                        }
                        sb.append("\ndo");
                        if (nonassociatedRows.size() == 1) {
                            sb.append("es");
                        }
                        sb.append(" not have end configurations.");
                        JOptionPane.showMessageDialog((Component)e.getSource(), sb.toString(), "Bad Rows Selected", 0);
                    }
                }
            });
        }
        if (((InputTableModel)this.table.getModel()).isMultiple) {
            bar.add(new AbstractAction("Edit File"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int k = MultipleSimulateAction.this.getMachineIndexBySelectedRow(MultipleSimulateAction.this.table);
                    if (k >= 0 && k < MultipleSimulateAction.this.getEnvironment().myObjects.size()) {
                        if (MultipleSimulateAction.this.getObject() instanceof Automaton) {
                            Automaton cur = (Automaton)MultipleSimulateAction.this.getEnvironment().myObjects.get(k);
                            EditorPane ep = new EditorPane(cur);
                            ep.setName(cur.getFileName());
                            MultipleSimulateAction.this.getEnvironment().add((Component)ep, "Edit", new CriticalTag(){});
                            MultipleSimulateAction.this.getEnvironment().setActive(ep);
                        } else if (MultipleSimulateAction.this.getObject() instanceof Grammar) {
                            Grammar cur = (Grammar)MultipleSimulateAction.this.getEnvironment().myObjects.get(k);
                            GrammarInputPane ep = new GrammarInputPane(cur);
                            ep.setName(cur.getFileName());
                            MultipleSimulateAction.this.getEnvironment().add((Component)ep, "Edit", new CriticalTag(){});
                            MultipleSimulateAction.this.getEnvironment().setActive(ep);
                        }
                    }
                }
            });
            bar.add(new AbstractAction("Add input string"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Object result;
                    String[] s;
                    Object input;
                    boolean inputsNeeded = true;
                    boolean turing = false;
                    if (MultipleSimulateAction.this.getEnvironment().myObjects.get(0) instanceof TuringMachine) {
                        turing = true;
                    }
                    if ((input = MultipleSimulateAction.this.initialInput(MultipleSimulateAction.this.getEnvironment().getActive(), "Input")) instanceof String) {
                        s = (String[])input;
                        MultipleSimulateAction.this.getEnvironment().myTestStrings.add((String)s);
                    } else if (input instanceof String[]) {
                        s = (String[])input;
                        int k = 0;
                        while (k < s.length) {
                            MultipleSimulateAction.this.getEnvironment().myTestStrings.add(s[k]);
                            ++k;
                        }
                    } else {
                        return;
                    }
                    if (turing) {
                        Object output = MultipleSimulateAction.this.initialInput(MultipleSimulateAction.this.getEnvironment().getActive(), "Expected Output?");
                        if (output instanceof String) {
                            String s2 = (String)output;
                            MultipleSimulateAction.this.getEnvironment().myTransducerStrings.add(s2);
                        } else if (output instanceof String[]) {
                            String[] s3 = (String[])output;
                            int k = 0;
                            while (k < s3.length) {
                                MultipleSimulateAction.this.getEnvironment().myTransducerStrings.add(s3[k]);
                                ++k;
                            }
                        } else {
                            MultipleSimulateAction.this.getEnvironment().myTestStrings.remove(MultipleSimulateAction.this.getEnvironment().myTestStrings.size() - 1);
                            return;
                        }
                    }
                    if ((result = MultipleSimulateAction.this.initialInput(MultipleSimulateAction.this.getEnvironment().getActive(), "Expected Result? (Accept or Reject)")) instanceof String) {
                        String s4 = (String)result;
                        MultipleSimulateAction.this.getEnvironment().myTransducerStrings.add(s4);
                    } else if (result instanceof String[]) {
                        String[] s5 = (String[])result;
                        MultipleSimulateAction.this.getEnvironment().myTransducerStrings.add(s5[0]);
                    } else {
                        MultipleSimulateAction.this.getEnvironment().myTestStrings.remove(MultipleSimulateAction.this.getEnvironment().myTestStrings.size() - 1);
                        MultipleSimulateAction.this.getEnvironment().myTransducerStrings.remove(MultipleSimulateAction.this.getEnvironment().myTestStrings.size() - 1);
                        return;
                    }
                    MultipleSimulateAction.this.getEnvironment().remove(MultipleSimulateAction.this.getEnvironment().getActive());
                    MultipleSimulateAction.this.performAction(MultipleSimulateAction.this.getEnvironment().getActive());
                }
            });
            bar.add(new AbstractAction("Add file"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TestAction test = new TestAction();
                    test.chooseFile(MultipleSimulateAction.this.getEnvironment().getActive(), false);
                    MultipleSimulateAction.this.getEnvironment().remove(MultipleSimulateAction.this.getEnvironment().getActive());
                    MultipleSimulateAction.this.performAction(MultipleSimulateAction.this.getEnvironment().getActive());
                }
            });
            bar.add(new AbstractAction("Remove file"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int k = MultipleSimulateAction.this.getMachineIndexBySelectedRow(MultipleSimulateAction.this.table);
                    if (k >= 0 && k < MultipleSimulateAction.this.getEnvironment().myObjects.size()) {
                        MultipleSimulateAction.this.getEnvironment().myObjects.remove(k);
                        int row = MultipleSimulateAction.this.table.getSelectedRow();
                        int objSize = MultipleSimulateAction.this.getEnvironment().myObjects.size();
                        int stringSize = MultipleSimulateAction.this.getEnvironment().myTestStrings.size();
                        int beginOffset = row % stringSize;
                        int begin = row - beginOffset;
                        int i = 0;
                        while (i < stringSize) {
                            ((InputTableModel)MultipleSimulateAction.this.table.getModel()).deleteRow(begin);
                            ++i;
                        }
                        MultipleSimulateAction.this.table.changeSelection(0, 0, false, false);
                    }
                }
            });
            bar.add(new AbstractAction("Save Results"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    final JFrame frame = new JFrame("Save Location");
                    JRadioButton defaultLocation = new JRadioButton("Save Results with Original File");
                    defaultLocation.setMnemonic(66);
                    defaultLocation.setActionCommand("Save Results with Original File");
                    defaultLocation.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                        }
                    });
                    final JRadioButton specifyLocation = new JRadioButton("Specify New Location");
                    specifyLocation.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                        }
                    });
                    specifyLocation.setMnemonic(67);
                    specifyLocation.setActionCommand("Specify New Location");
                    defaultLocation.setSelected(true);
                    ButtonGroup group = new ButtonGroup();
                    group.add(defaultLocation);
                    group.add(specifyLocation);
                    JPanel panel = new JPanel();
                    panel.add(defaultLocation);
                    panel.add(specifyLocation);
                    frame.getContentPane().add((Component)panel, "Center");
                    JButton accept = new JButton("Accept");
                    accept.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            frame.setVisible(false);
                            String filepath = "";
                            boolean failedSave = false;
                            if (specifyLocation.isSelected()) {
                                File file = null;
                                boolean badname = false;
                                while (badname || file == null) {
                                    if (badname) continue;
                                    Universe.CHOOSER.setFileFilter(null);
                                    Universe.CHOOSER.setDialogTitle("Choose directory to save files in");
                                    Universe.CHOOSER.setFileSelectionMode(1);
                                    int result = Universe.CHOOSER.showSaveDialog(frame);
                                    if (result != 0) break;
                                    file = Universe.CHOOSER.getSelectedFile();
                                    try {
                                        filepath = file.getCanonicalPath();
                                        int last = filepath.lastIndexOf("\\");
                                        if (last == -1) {
                                            filepath = String.valueOf(filepath) + "/";
                                            continue;
                                        }
                                        filepath = String.valueOf(filepath) + "\\";
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            if (filepath.equals("")) {
                                failedSave = true;
                            }
                            InputTableModel model = (InputTableModel)(this).MultipleSimulateAction.this.table.getModel();
                            String oldfileName = (String)model.getValueAt(0, 0);
                            String fileName = (String)model.getValueAt(0, 0);
                            boolean turing = false;
                            Object machine = (this).MultipleSimulateAction.this.getEnvironment().myObjects.get(0);
                            String base = filepath;
                            if (machine instanceof Automaton) {
                                if (machine instanceof TuringMachine) {
                                    turing = true;
                                }
                                if (failedSave) {
                                    base = ((Automaton)machine).getFilePath();
                                }
                            } else if (machine instanceof Grammar && failedSave) {
                                base = ((Grammar)machine).getFilePath();
                            }
                            try {
                                FileWriter writer = new FileWriter(String.valueOf(base) + "results" + fileName + ".txt");
                                BufferedWriter bwriter = new BufferedWriter(writer);
                                PrintWriter out = new PrintWriter(bwriter);
                                int r = 0;
                                while (r < model.getRowCount()) {
                                    fileName = (String)model.getValueAt(r, 0);
                                    if (!fileName.equals(oldfileName)) {
                                        oldfileName = fileName;
                                        out.flush();
                                        out.close();
                                        if (fileName.equals("")) break;
                                        int index = MultipleSimulateAction.this.getMachineIndexByName(fileName);
                                        machine = (this).MultipleSimulateAction.this.getEnvironment().myObjects.get(index);
                                        if (machine instanceof Automaton) {
                                            if (!specifyLocation.isSelected() || failedSave) {
                                                base = ((Automaton)machine).getFilePath();
                                            }
                                        } else if (machine instanceof Grammar && (!specifyLocation.isSelected() || failedSave)) {
                                            base = ((Grammar)machine).getFilePath();
                                        }
                                        bwriter = new BufferedWriter(new FileWriter(String.valueOf(base) + "results" + fileName + ".txt"));
                                        out = new PrintWriter(bwriter);
                                    }
                                    boolean input = false;
                                    boolean end = false;
                                    boolean output = false;
                                    int c = 1;
                                    while (c < model.getColumnCount()) {
                                        if (model.getColumnName(c).startsWith("Input") && !input) {
                                            out.write("Input: ");
                                            input = true;
                                        }
                                        if (model.getColumnName(c).startsWith("Output") && !output && turing) {
                                            out.write("Output: ");
                                            output = true;
                                        }
                                        if (model.getColumnName(c).startsWith("Result")) {
                                            end = true;
                                            out.write("Result: ");
                                        }
                                        String value = (String)model.getValueAt(r, c);
                                        out.write(String.valueOf(value) + " ");
                                        try {
                                            if (end) {
                                                bwriter.newLine();
                                            }
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                        ++c;
                                    }
                                    ++r;
                                }
                                out.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                    frame.getContentPane().add((Component)accept, "South");
                    frame.pack();
                    Point point = new Point(100, 50);
                    frame.setLocation(point);
                    frame.setVisible(true);
                }
            });
        }
        this.myPanel = panel;
        Object finObject = this.getObject();
        if (finObject instanceof Automaton) {
            AutomatonPane ap = new AutomatonPane((Automaton)finObject);
            ap.addMouseListener(new ArrowDisplayOnlyTool(ap, ap.getDrawer()));
            JSplitPane split = SplitPaneFactory.createSplit(this.getEnvironment(), true, 0.5, ap, panel);
            MultiplePaneWBar mp = new MultiplePaneWBar(split, bar);
            this.getEnvironment().add((Component)mp, this.getComponentTitle(), new CriticalTag(){});
            this.getEnvironment().setActive(mp);
        } else if (finObject instanceof Grammar) {
            BruteParsePane bp = new BruteParsePane((GrammarEnvironment)this.getEnvironment(), (Grammar)finObject, (InputTableModel)this.table.getModel());
            bp.inputField.setEditable(false);
            if (this.getEnvironment().myTestStrings != null && this.getEnvironment().myTestStrings.size() > 0) {
                bp.inputField.setText(this.getEnvironment().myTestStrings.get(0));
            }
            JSplitPane split = SplitPaneFactory.createSplit(this.getEnvironment(), true, 0.5, bp, panel);
            MultiplePane mp = new MultiplePane(split);
            this.getEnvironment().add((Component)mp, this.getComponentTitle(), new CriticalTag(){});
            this.getEnvironment().setActive(mp);
        }
    }

    private int getMachineIndexBySelectedRow(JTable table) {
        InputTableModel model = (InputTableModel)table.getModel();
        int row = table.getSelectedRow();
        if (row < 0) {
            return -1;
        }
        String machineFileName = (String)model.getValueAt(row, 0);
        return this.getMachineIndexByName(machineFileName);
    }

    public int getMachineIndexByName(String machineFileName) {
        ArrayList<Object> machines = this.getEnvironment().myObjects;
        if (machines == null) {
            return -1;
        }
        int k = 0;
        while (k < machines.size()) {
            Cloneable cur;
            Object current = machines.get(k);
            if (current instanceof Automaton ? ((Automaton)(cur = (Automaton)current)).getFileName().equals(machineFileName) : current instanceof Grammar && ((Grammar)(cur = (Grammar)current)).getFileName().equals(machineFileName)) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public void viewAutomaton(JTableExtender table) {
        InputTableModel model = (InputTableModel)table.getModel();
        if (model.isMultiple) {
            int row = table.getSelectedRow();
            if (row < 0) {
                return;
            }
            String machineFileName = (String)model.getValueAt(row, 0);
            this.updateView(machineFileName, (String)model.getValueAt(row, 1), table);
        } else if (this.getEnvironment().getObject() instanceof Grammar) {
            this.updateView(((Grammar)this.getEnvironment().getObject()).getFileName(), (String)model.getValueAt(table.getSelectedRow(), 1), table);
        } else if (this.getEnvironment().getObject() instanceof Automaton) {
            this.updateView(((Automaton)this.getEnvironment().getObject()).getFileName(), (String)model.getValueAt(table.getSelectedRow(), 1), table);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.performAction((Component)e.getSource());
    }

    protected void updateView(String machineFileName, String input, JTableExtender table) {
        ArrayList<Object> machines = this.getEnvironment().myObjects;
        Object current = null;
        current = machines != null ? machines.get(0) : this.getEnvironment().getObject();
        if (current instanceof Automaton && ((InputTableModel)table.getModel()).isMultiple) {
            int spot = this.getMachineIndexBySelectedRow(table);
            Automaton cur = null;
            cur = spot != -1 ? (Automaton)machines.get(spot) : (Automaton)this.getEnvironment().getObject();
            AutomatonPane newAP = new AutomatonPane(cur);
            newAP.addMouseListener(new ArrowDisplayOnlyTool(newAP, newAP.getDrawer()));
            JSplitPane split = SplitPaneFactory.createSplit(this.getEnvironment(), true, 0.5, newAP, this.myPanel);
            MultiplePaneWBar mp = new MultiplePaneWBar(split, new JToolBar());
            EnvironmentFrame frame = Universe.frameForEnvironment(this.getEnvironment());
            String newTitle = cur.getFileName();
            if (newTitle != "") {
                frame.setTitle(newTitle);
            }
            this.getEnvironment().remove(this.getEnvironment().getActive());
            this.getEnvironment().add((Component)mp, this.getComponentTitle(), new CriticalTag(){});
            this.getEnvironment().setActive(mp);
        } else if (current instanceof Grammar && table.getSelectedRow() < table.getRowCount() - 1) {
            int spot = this.getMachineIndexBySelectedRow(table);
            Grammar cur = null;
            cur = spot != -1 ? (Grammar)machines.get(spot) : (Grammar)this.getEnvironment().getObject();
            BruteParsePane bp = new BruteParsePane((GrammarEnvironment)this.getEnvironment(), cur, null);
            int column = 1;
            if (spot == -1) {
                column = 0;
            }
            bp.inputField.setText((String)table.getModel().getValueAt(table.getSelectedRow(), column));
            bp.inputField.setEditable(false);
            JSplitPane split = SplitPaneFactory.createSplit(this.getEnvironment(), true, 0.5, bp, this.myPanel);
            MultiplePane mp = new MultiplePane(split);
            this.getEnvironment().add((Component)mp, this.getComponentTitle(), new CriticalTag(){});
            EnvironmentFrame frame = Universe.frameForEnvironment(this.getEnvironment());
            String newTitle = cur.getFileName();
            if (newTitle != "") {
                frame.setTitle(newTitle);
            }
            this.getEnvironment().remove(this.getEnvironment().getActive());
            this.getEnvironment().add((Component)mp, this.getComponentTitle(), new CriticalTag(){});
            this.getEnvironment().setActive(mp);
        }
    }

    public class MultiplePane
    extends JPanel {
        private static final long serialVersionUID = 1L;
        public JSplitPane mySplit;

        public MultiplePane(JSplitPane split) {
            super(new BorderLayout());
            this.mySplit = null;
            this.add((Component)split, "Center");
            this.mySplit = split;
        }
    }

    public class MultiplePaneWBar
    extends JPanel {
        private static final long serialVersionUID = 1L;
        public JSplitPane mySplit;

        public MultiplePaneWBar(JSplitPane split, JToolBar bar) {
            super(new BorderLayout());
            this.mySplit = null;
            this.add((Component)split, "Center");
            this.mySplit = split;
            System.out.println("here we go");
            this.add((Component)bar, "South");
        }
    }
}

