/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.graph.AutomatonGraph;
import automata.graph.LayoutAlgorithm;
import automata.graph.LayoutAlgorithmFactory;
import automata.mealy.MealyMachine;
import automata.pda.PushdownAutomaton;
import automata.turing.TuringMachine;
import gui.action.AutomatonAction;
import gui.environment.Environment;
import java.awt.Dimension;
import java.awt.event.ActionEvent;

public class LayoutAlgorithmAction
extends AutomatonAction {
    private static final long serialVersionUID = 1L;
    private final Dimension assumedUsedSpace = new Dimension(25, 100);
    private Automaton automaton;
    private Environment environment;
    private int algorithm;

    public LayoutAlgorithmAction(String s, Automaton a, Environment e, int algm) {
        super(s, null);
        this.automaton = a;
        this.environment = e;
        this.algorithm = algm;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double vertexBuffer = this.automaton instanceof TuringMachine ? (double)(80 * ((TuringMachine)this.automaton).tapes()) : (this.automaton instanceof PushdownAutomaton ? 80.0 : (this.automaton instanceof MealyMachine ? 65.0 : 50.0));
        AutomatonGraph graph = LayoutAlgorithmFactory.getAutomatonGraph(this.algorithm, this.automaton);
        LayoutAlgorithm layout = LayoutAlgorithmFactory.getLayoutAlgorithm(this.algorithm, new Dimension((int)this.environment.getSize().getWidth() - (int)this.assumedUsedSpace.getWidth(), (int)this.environment.getSize().getHeight() - (int)this.assumedUsedSpace.getHeight()), new Dimension(30, 30), vertexBuffer);
        layout.layout(graph, null);
        graph.moveAutomatonStates();
    }
}

