/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import gui.TooltipAction;
import gui.action.AutomatonAction;
import gui.environment.AutomatonEnvironment;
import gui.environment.tag.CriticalTag;
import gui.grammar.automata.ConvertController;
import gui.grammar.automata.ConvertPane;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;

public abstract class ConvertAutomatonToGrammarAction
extends AutomatonAction {
    private static final long serialVersionUID = 1L;
    private AutomatonEnvironment environment;
    private Automaton automaton;
    private ConvertController controller;

    public ConvertAutomatonToGrammarAction(AutomatonEnvironment environment) {
        super("Convert to Grammar", null);
        this.environment = environment;
        this.automaton = environment.getAutomaton();
    }

    public ConvertAutomatonToGrammarAction(String title, AutomatonEnvironment environment) {
        super(title, null);
        this.environment = environment;
        this.automaton = environment.getAutomaton();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.automaton.getInitialState() == null) {
            JOptionPane.showMessageDialog(this.environment, "There must be an initial state!", "No Initial State", 0);
            return;
        }
        if (!this.checkAutomaton()) {
            return;
        }
        Automaton a = (Automaton)this.getAutomaton().clone();
        ConvertPane pane = new ConvertPane(this.environment, a);
        final ConvertController controller = this.initializeController(pane, pane.getDrawer(), a);
        AutomatonPane apane = pane.getAutomatonPane();
        apane.addMouseListener(new MouseAdapter(pane){
            private SelectionDrawer drawer;
            {
                this.drawer = convertPane.getDrawer();
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                Serializable o = this.drawer.stateAtPoint(event.getPoint());
                if (o == null) {
                    o = this.drawer.transitionAtPoint(event.getPoint());
                }
                if (o == null) {
                    return;
                }
                controller.revealObjectProductions(o);
            }
        });
        JToolBar toolbar = this.initToolbar(controller);
        pane.add((Component)toolbar, "North");
        this.environment.add((Component)pane, "Convert to Grammar", new CriticalTag(){});
        this.environment.setActive(pane);
    }

    private JToolBar initToolbar(final ConvertController controller) {
        JToolBar bar = new JToolBar();
        bar.add(new TooltipAction("Hint", "Shows the productions for one object."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.revealRandomProductions();
            }
        });
        bar.add(new TooltipAction("Show All", "Shows all productions remaining."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.revealAllProductions();
            }
        });
        bar.addSeparator();
        bar.add(new TooltipAction("What's Left?", "Highlights remaining objects to convert."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.highlightUntransformed();
            }
        });
        bar.add(new TooltipAction("Export", "Exports a finished grammar to a new window."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.exportGrammar();
            }
        });
        return bar;
    }

    protected abstract boolean checkAutomaton();

    protected abstract ConvertController initializeController(ConvertPane var1, SelectionDrawer var2, Automaton var3);

    protected Automaton getAutomaton() {
        return this.automaton;
    }

    protected AutomatonEnvironment getEnvironment() {
        return this.environment;
    }
}

