/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TripleTextFieldSizeSlider
extends JSlider {
    private static final long serialVersionUID = 1L;
    static final int FONT_SIZE_MIN = 1;
    static final int FONT_SIZE_MAX = 600;
    static final int FONT_SIZE_INIT = 300;
    static String TEXTFIELD_SIZE_TITLE = "Input Field Text Size (For optimization, move one of the window size adjustors around this window after resizing the text field)";
    JTextField myField1;
    JTextField myField2;
    JTextField myField3;

    public TripleTextFieldSizeSlider(JTextField field1, JTextField field2, JTextField field3, int orientation, String title) {
        super(orientation, 1, 600, 300);
        if (title.equals("Input Field Text Size")) {
            title = TEXTFIELD_SIZE_TITLE;
        }
        this.addChangeListener(new SliderListener());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
        this.myField1 = field1;
        this.myField2 = field2;
        this.myField3 = field3;
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            TripleTextFieldSizeSlider.this.myField1.setFont(new Font("Default", 0, source.getValue() / 10));
            TripleTextFieldSizeSlider.this.myField1.setSize(TripleTextFieldSizeSlider.this.myField1.getWidth(), source.getValue() / 10 + 10);
            TripleTextFieldSizeSlider.this.myField2.setFont(new Font("Default", 0, source.getValue() / 10));
            TripleTextFieldSizeSlider.this.myField2.setSize(TripleTextFieldSizeSlider.this.myField2.getWidth(), source.getValue() / 10 + 10);
            TripleTextFieldSizeSlider.this.myField3.setFont(new Font("Default", 0, source.getValue() / 10));
            TripleTextFieldSizeSlider.this.myField3.setSize(TripleTextFieldSizeSlider.this.myField3.getWidth(), source.getValue() / 10 + 10);
        }
    }
}

