/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.ParseNode;
import grammar.parse.RestrictedUserParser;
import grammar.parse.Unrestricted;
import grammar.parse.UnrestrictedUserParser;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;

public abstract class UserParser {
    private static final Production[] P = new Production[0];
    private static final int[] S = new int[0];
    private static final ParseNode E = new ParseNode("", P, S);
    protected Grammar myGrammar;
    protected Production[] myProductions;
    protected String myTarget;
    private boolean isDone = false;
    private ParseNode myAnswer;
    protected Set<String> mySmallerSet;
    private Production myCurrentProduction;
    private int myCount = 0;
    private LinkedList<ParseNode> myQueue = new LinkedList();

    public UserParser(Grammar grammar, String target) {
        this.initialize(grammar, target);
    }

    private void initialize(Grammar grammar, String target) {
        int i = 0;
        while (i < target.length()) {
            if (!grammar.isTerminal(target.substring(i, i + 1))) {
                throw new IllegalArgumentException("String to parse has nonterminal " + target.substring(i, i + 1) + ".");
            }
            ++i;
        }
        if (grammar == null) {
            return;
        }
        this.myQueue.clear();
        this.myAnswer = new ParseNode(grammar.getStartVariable(), P, S);
        this.myQueue.add(this.myAnswer);
        this.mySmallerSet = Collections.unmodifiableSet(Unrestricted.smallerSymbols(grammar));
        this.myGrammar = grammar;
        this.myProductions = grammar.getProductions();
        this.myTarget = target;
    }

    public static UserParser get(Grammar grammar, String target) {
        if (Unrestricted.isUnrestricted(grammar)) {
            return new UnrestrictedUserParser(grammar, target);
        }
        return new RestrictedUserParser(grammar, target);
    }

    public int checkValidAndParse(int index) {
        this.myCurrentProduction = this.myProductions[index];
        int length = this.myCurrentProduction.getLHS().length();
        int count = 0;
        int i = 0;
        while (i < this.myAnswer.getDerivation().length()) {
            if (i + length > this.myAnswer.getDerivation().length()) break;
            if (this.myAnswer.getDerivation().substring(i, i + length).equals(this.myCurrentProduction.getLHS())) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private ParseNode getNextResult(String c, int index) {
        if (c.length() == 0) {
            return E;
        }
        int start = 0;
        if (index < 0) {
            index = c.indexOf(this.myCurrentProduction.getLHS());
        }
        start = index;
        String prepend = String.valueOf(c.substring(0, start)) + this.myCurrentProduction.getRHS() + c.substring(start + this.myCurrentProduction.getLHS().length());
        Production[] singleProductionArray = new Production[]{this.myCurrentProduction};
        int[] singleSubstitutionArray = new int[]{start};
        return new ParseNode(prepend, singleProductionArray, singleSubstitutionArray);
    }

    public boolean isPossibleDerivation(String derivation) {
        return Unrestricted.minimumLength(derivation, this.mySmallerSet) <= this.myTarget.length();
    }

    public synchronized void parse(int index) {
        if (this.myCount == 0) {
            ++this.myCount;
            return;
        }
        ParseNode node = this.myQueue.removeFirst();
        ParseNode pNode = this.getNextResult(this.myAnswer.getDerivation(), index);
        pNode = new ParseNode(pNode);
        node.add(pNode);
        this.myQueue.add(pNode);
        this.myAnswer = pNode;
        if (pNode.getDerivation().equals(this.myTarget)) {
            this.isDone = true;
            return;
        }
        this.isDone = false;
    }

    public synchronized boolean start() {
        if (this.isFinished()) {
            return false;
        }
        this.parse(-1);
        return true;
    }

    public synchronized boolean isFinished() {
        return this.isDone;
    }

    public synchronized ParseNode getAnswer() {
        return this.myAnswer;
    }

    public synchronized ParseNode getPreviousAnswer() {
        this.myAnswer = (ParseNode)this.myAnswer.getParent();
        this.myQueue.clear();
        this.myQueue.add(this.myAnswer);
        return this.myAnswer;
    }

    public String getLHSForProduction(int selectedRow) {
        return this.myProductions[selectedRow].getLHS();
    }

    public void subsitute(int[] tempIndices) {
        ParseNode node = this.myQueue.removeFirst();
        ParseNode pNode = this.getNextSubstitution(this.myAnswer.getDerivation(), tempIndices);
        pNode = new ParseNode(pNode);
        node.add(pNode);
        this.myQueue.add(pNode);
        this.myAnswer = pNode;
        if (pNode.getDerivation().equals(this.myTarget)) {
            this.isDone = true;
            return;
        }
        this.isDone = false;
    }

    private ParseNode getNextSubstitution(String c, int[] tempIndices) {
        int[] multipleSubstitutionArray = tempIndices;
        int start = 0;
        String prepend = "";
        Production[] multipleProductionArray = new Production[multipleSubstitutionArray.length];
        multipleProductionArray[0] = this.myCurrentProduction;
        int i = 0;
        while (i < multipleSubstitutionArray.length) {
            start = i == 0 ? multipleSubstitutionArray[i] : multipleSubstitutionArray[i] + i * (this.myCurrentProduction.getRHS().length() - 1);
            c = prepend = String.valueOf(c.substring(0, start)) + this.myCurrentProduction.getRHS() + c.substring(start + this.myCurrentProduction.getLHS().length());
            multipleProductionArray[i] = this.myCurrentProduction;
            ++i;
        }
        return new ParseNode(prepend, multipleProductionArray, multipleSubstitutionArray);
    }

    public boolean isStringTerminal(String finalString) {
        int i = 0;
        while (i < this.myProductions.length) {
            if (finalString.contains(this.myProductions[i].getLHS())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

