/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.Grammar;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;

public class LLParseTable
extends AbstractTableModel
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String[] terminals;
    private String[] variables;
    private SortedSet<String>[][] entries;
    private boolean frozen = false;

    public LLParseTable(Grammar grammar) {
        this.variables = grammar.getVariables();
        Arrays.sort(this.variables);
        this.terminals = grammar.getTerminals();
        Arrays.sort(this.terminals);
        this.entries = new SortedSet[this.variables.length][this.terminals.length + 1];
        int i = 0;
        while (i < this.entries.length) {
            int j = 0;
            while (j < this.entries[i].length) {
                this.entries[i][j] = new TreeSet<String>();
                ++j;
            }
            ++i;
        }
    }

    public LLParseTable(LLParseTable table) {
        this.variables = table.variables;
        this.terminals = table.terminals;
        this.entries = new SortedSet[this.variables.length][this.terminals.length + 1];
        int i = 0;
        while (i < this.entries.length) {
            int j = 0;
            while (j < this.entries[i].length) {
                this.entries[i][j] = new TreeSet<String>(table.entries[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public Object clone() {
        return new LLParseTable(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        try {
            LLParseTable other = (LLParseTable)object;
            if (!Arrays.equals(this.variables, other.variables)) {
                return false;
            }
            if (!Arrays.equals(this.terminals, other.terminals)) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= this.variables.length) {
                    return true;
                }
                if (!Arrays.equals(this.entries[i], other.entries[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.variables.length ^ this.terminals.length;
    }

    private int[] getLocation(String variable, String lookahead) {
        int[] r = new int[]{this.getRow(variable), this.getColumn(lookahead) - 1};
        return r;
    }

    public int getRow(String variable) {
        int row = Arrays.binarySearch(this.variables, variable);
        if (row < 0) {
            throw new IllegalArgumentException(String.valueOf(variable) + " is not a variable!");
        }
        return row;
    }

    public int getColumn(String lookahead) {
        int column = this.terminals.length;
        if (!lookahead.equals("$")) {
            column = Arrays.binarySearch(this.terminals, lookahead);
        }
        if (column < 0) {
            throw new IllegalArgumentException(String.valueOf(lookahead) + " is not a terminal!");
        }
        return column + 1;
    }

    public String[][] getDifferences(LLParseTable table) {
        if (!Arrays.equals(this.variables, table.variables) || !Arrays.equals(this.terminals, table.terminals)) {
            throw new IllegalArgumentException("Tables differ in variables or terminals.");
        }
        ArrayList<String[]> differences = new ArrayList<String[]>();
        int v = 0;
        while (v < this.entries.length) {
            int t = 0;
            while (t < this.entries[v].length) {
                if (!this.entries[v][t].equals(table.entries[v][t])) {
                    if (t == this.terminals.length) {
                        differences.add(new String[]{this.variables[v], "$"});
                    } else {
                        differences.add(new String[]{this.variables[v], this.terminals[t]});
                    }
                }
                ++t;
            }
            ++v;
        }
        return (String[][])differences.toArray((T[])new String[0][0]);
    }

    public int addEntry(String variable, String lookahead, String expansion) {
        int[] r = this.getLocation(variable, lookahead);
        this.entries[r[0]][r[1]].add(expansion);
        this.fireTableCellUpdated(r[0], r[1] + 1);
        return this.entries[r[0]][r[1]].size();
    }

    public boolean removeEntry(String variable, String lookahead, String expansion) {
        int[] r = this.getLocation(variable, lookahead);
        boolean removed = this.entries[r[0]][r[1]].remove(expansion);
        this.fireTableCellUpdated(r[0], r[1] + 1);
        return removed;
    }

    public void clear() {
        int i = 0;
        while (i < this.entries.length) {
            int j = 0;
            while (j < this.entries[i].length) {
                this.entries[i][j].clear();
                ++j;
            }
            ++i;
        }
        this.fireTableDataChanged();
    }

    public void clear(String variable, String lookahead) {
        int[] r = this.getLocation(variable, lookahead);
        this.entries[r[0]][r[1]].clear();
        this.fireTableCellUpdated(r[0], r[1] + 1);
    }

    public SortedSet<String> get(String variable, String lookahead) {
        int[] r = this.getLocation(variable, lookahead);
        return Collections.unmodifiableSortedSet(this.entries[r[0]][r[1]]);
    }

    public void set(Set<String> productions, String variable, String lookahead) {
        int[] r = this.getLocation(variable, lookahead);
        this.entries[r[0]][r[1]].clear();
        this.entries[r[0]][r[1]].addAll(productions);
    }

    @Override
    public int getRowCount() {
        return this.variables.length;
    }

    @Override
    public int getColumnCount() {
        return this.terminals.length + 2;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return " ";
        }
        if (column == this.terminals.length + 1) {
            return "$";
        }
        return this.terminals[column - 1];
    }

    private String spaceSet(Set<?> set) {
        Iterator<?> it = set.iterator();
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            String s;
            if (!first) {
                sb.append(" ");
            }
            sb.append((s = (String)it.next()).equals("") ? "!" : s);
            first = false;
        }
        return sb.toString();
    }

    private int despaceSet(String string, Set<String> set) {
        set.clear();
        StringTokenizer st = new StringTokenizer(string);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("!")) {
                s = "";
            }
            set.add(s);
        }
        return set.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.variables[row];
        }
        return this.spaceSet(this.entries[row][column - 1]);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.despaceSet((String)value, this.entries[row][column - 1]);
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.frozen) {
            return false;
        }
        return column != 0;
    }

    public void setEditable(boolean editable) {
        this.frozen = !editable;
    }
}

