/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.BruteParserEvent;
import grammar.parse.BruteParserListener;
import grammar.parse.ParseNode;
import grammar.parse.RestrictedBruteParser;
import grammar.parse.Unrestricted;
import grammar.parse.UnrestrictedBruteParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BruteParser {
    private static final Production[] P = new Production[0];
    private static final int[] S = new int[0];
    private static final ParseNode E = new ParseNode("", P, S);
    protected Set<BruteParserListener> listeners = new HashSet<BruteParserListener>();
    protected Grammar grammar;
    protected Production[] productions;
    protected String target;
    private boolean isDone = false;
    private Thread parseThread = null;
    private Set<String> alreadyAdded = new HashSet<String>();
    private Map<String, List<ParseNode>> prederived = new HashMap<String, List<ParseNode>>();
    protected LinkedList<ParseNode> queue = new LinkedList();
    private int consideredNodes = 0;
    private int beingConsideredNodes = 0;
    private int deletedNodes = 0;
    private ParseNode answer = null;
    protected Set<String> smaller;

    protected BruteParser() {
    }

    public BruteParser(Grammar grammar, String target) {
        this.init(grammar, target);
    }

    public static BruteParser get(Grammar grammar, String target) {
        if (Unrestricted.isUnrestricted(grammar)) {
            return new UnrestrictedBruteParser(grammar, target);
        }
        return new RestrictedBruteParser(grammar, target);
    }

    protected void init(Grammar grammar, String target) {
        int i = 0;
        while (i < target.length()) {
            if (!grammar.isTerminal(target.substring(i, i + 1))) {
                throw new IllegalArgumentException("String to parse has nonterminal " + target.substring(i, i + 1) + ".");
            }
            ++i;
        }
        this.queue.clear();
        grammar = Unrestricted.optimize(grammar);
        if (grammar == null) {
            return;
        }
        this.queue.add(new ParseNode(grammar.getStartVariable(), P, S));
        this.consideredNodes = 0;
        this.deletedNodes = 0;
        this.smaller = Collections.unmodifiableSet(Unrestricted.smallerSymbols(grammar));
        Collections.unmodifiableSet(Unrestricted.smallerSymbols(grammar));
        this.grammar = grammar;
        this.productions = grammar.getProductions();
        this.target = target;
    }

    public synchronized boolean start() {
        if (this.isActive() || this.isFinished()) {
            return false;
        }
        this.parseThread = new Thread(){

            @Override
            public void run() {
                while (BruteParser.this.parseThread != null) {
                    BruteParser.this.parse();
                }
            }
        };
        this.parseThread.start();
        this.distributeEvent(new BruteParserEvent(this, 0));
        return true;
    }

    public synchronized void pause() {
        this.parseThread = null;
        this.distributeEvent(new BruteParserEvent(this, 1));
    }

    public synchronized boolean isActive() {
        return this.parseThread != null;
    }

    public synchronized boolean isFinished() {
        return this.isDone;
    }

    public synchronized ParseNode getAnswer() {
        return this.answer;
    }

    private List<ParseNode> getPossibilities(String c) {
        ArrayList<ParseNode> possibilities = new ArrayList<ParseNode>();
        if (this.prederived.containsKey(c)) {
            return this.prederived.get(c);
        }
        HashSet<String> alreadyEncountered = new HashSet<String>();
        if (c.length() == 0) {
            possibilities.add(E);
            return possibilities;
        }
        int i = -1;
        while (i < this.productions.length) {
            Production prod = i == -1 ? new Production(c.substring(0, 1), c.substring(0, 1)) : this.productions[i];
            int start = c.indexOf(prod.getLHS());
            int lengthSubs = prod.getLHS().length();
            if (start != -1) {
                List<ParseNode> list = this.getPossibilities(c.substring(start + lengthSubs));
                Iterator<ParseNode> it = list.iterator();
                String prepend = String.valueOf(c.substring(0, start)) + prod.getRHS();
                int lengthReplace = start + prod.getLHS().length();
                while (it.hasNext()) {
                    ParseNode node = it.next();
                    String d = node.getDerivation();
                    Production[] p = node.getProductions();
                    String a = String.valueOf(prepend) + d;
                    int[] s = node.getSubstitutions();
                    if (i == -1) {
                        int[] newS = new int[s.length];
                        int j = 0;
                        while (j < p.length) {
                            newS[j] = s[j] + lengthReplace;
                            ++j;
                        }
                        if (!alreadyEncountered.add(a)) continue;
                        node = new ParseNode(a, p, newS);
                        possibilities.add(node);
                        ++this.beingConsideredNodes;
                        continue;
                    }
                    Production[] newP = new Production[p.length + 1];
                    int[] newS = new int[s.length + 1];
                    newS[0] = start;
                    newP[0] = prod;
                    int j = 0;
                    while (j < p.length) {
                        newP[j + 1] = p[j];
                        newS[j + 1] = s[j] + lengthReplace;
                        ++j;
                    }
                    if (!alreadyEncountered.add(a)) continue;
                    node = new ParseNode(a, newP, newS);
                    possibilities.add(node);
                    ++this.beingConsideredNodes;
                }
            }
            ++i;
        }
        return possibilities;
    }

    private void removeFutility(ParseNode node) {
        try {
            while (node.isLeaf()) {
                ((ParseNode)node.getParent()).remove(node);
                ++this.deletedNodes;
                node = (ParseNode)node.getParent();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public int getCurrentNodeCount() {
        return this.consideredNodes - this.deletedNodes;
    }

    public int getTotalNodeCount() {
        return this.consideredNodes;
    }

    public int getConsiderationNodeCount() {
        return this.beingConsideredNodes;
    }

    public boolean isPossibleDerivation(String derivation) {
        return Unrestricted.minimumLength(derivation, this.smaller) <= this.target.length();
    }

    private synchronized void parse() {
        if (this.queue.isEmpty()) {
            this.isDone = true;
            this.parseThread = null;
            this.distributeEvent(new BruteParserEvent(this, 3));
            return;
        }
        ParseNode node = this.queue.removeFirst();
        this.beingConsideredNodes = 0;
        List<ParseNode> pos = this.getPossibilities(node.getDerivation());
        this.beingConsideredNodes = 0;
        for (ParseNode pNode : pos) {
            if (!this.alreadyAdded.add(pNode.getDerivation()) || !this.isPossibleDerivation(pNode.getDerivation())) continue;
            pNode = new ParseNode(pNode);
            node.add(pNode);
            this.queue.add(pNode);
            ++this.consideredNodes;
            if (!pNode.getDerivation().equals(this.target)) continue;
            this.answer = pNode;
            this.isDone = true;
            this.parseThread = null;
            this.queue.clear();
            this.distributeEvent(new BruteParserEvent(this, 2));
            return;
        }
        if (node.isLeaf()) {
            this.removeFutility(node);
        }
    }

    public void addBruteParserListener(BruteParserListener listener) {
        this.listeners.add(listener);
    }

    public void removeBruteParserListener(BruteParserListener listener) {
        this.listeners.remove(listener);
    }

    protected void distributeEvent(BruteParserEvent event) {
        Iterator<BruteParserListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().bruteParserStateChange(event);
        }
    }
}

