/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import grammar.Grammar;
import grammar.GrammarChecker;
import grammar.Production;
import grammar.ProductionChecker;
import grammar.cfg.ContextFreeGrammar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class LambdaProductionRemover {
    protected String ZERO = "0";
    protected char ONE_CHAR = (char)49;

    public HashSet<String> getNewLambdaSet() {
        return new HashSet<String>();
    }

    public void addVariableToLambdaSet(String variable, Set<String> lambdaSet) {
        if (!lambdaSet.contains(variable)) {
            lambdaSet.add(variable);
        }
    }

    public boolean isVariableWithLambdaProduction(String variable, Grammar grammar) {
        ProductionChecker pc = new ProductionChecker();
        GrammarChecker gc = new GrammarChecker();
        Production[] productions = GrammarChecker.getProductionsOnVariable(variable, grammar);
        int k = 0;
        while (k < productions.length) {
            if (ProductionChecker.isLambdaProduction(productions[k])) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public boolean areMoreVariablesWithLambdaProductions(Grammar grammar, Set<String> lambdaSet) {
        return this.getNewVariableWithLambdaProduction(grammar, lambdaSet) != null;
    }

    public String getNewVariableWithLambdaProduction(Grammar grammar, Set<String> lambdaSet) {
        String[] variables = grammar.getVariables();
        int k = 0;
        while (k < variables.length) {
            if (!lambdaSet.contains(variables[k]) && this.isVariableWithLambdaProduction(variables[k], grammar)) {
                return variables[k];
            }
            ++k;
        }
        return null;
    }

    public void addVariablesWithLambdaProductions(Grammar grammar, Set<String> lambdaSet) {
        while (this.areMoreVariablesWithLambdaProductions(grammar, lambdaSet)) {
            String variable = this.getNewVariableWithLambdaProduction(grammar, lambdaSet);
            this.addVariableToLambdaSet(variable, lambdaSet);
        }
    }

    public boolean isInLambdaSet(String variable, Set<String> lambdaSet) {
        return lambdaSet.contains(variable);
    }

    public boolean isReducableToLambdaProduction(Production production, Set<String> lambdaSet) {
        ProductionChecker pc = new ProductionChecker();
        if (ProductionChecker.areTerminalsOnRHS(production)) {
            return false;
        }
        String[] variables = production.getVariablesOnRHS();
        int j = 0;
        while (j < variables.length) {
            if (!this.isInLambdaSet(variables[j], lambdaSet)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public boolean belongsInLambdaSet(String variable, Grammar grammar, Set<String> lambdaSet) {
        if (this.isVariableWithLambdaProduction(variable, grammar)) {
            return true;
        }
        GrammarChecker gc = new GrammarChecker();
        Production[] productions = GrammarChecker.getProductionsOnVariable(variable, grammar);
        int k = 0;
        while (k < productions.length) {
            if (this.isReducableToLambdaProduction(productions[k], lambdaSet)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public boolean areMoreVariablesToAddToLambdaSet(Grammar grammar, Set<String> lambdaSet) {
        return this.getNewVariableThatBelongsInLambdaSet(grammar, lambdaSet) != null;
    }

    public String getNewVariableThatBelongsInLambdaSet(Grammar grammar, Set<String> lambdaSet) {
        String[] variables = grammar.getVariables();
        int k = 0;
        while (k < variables.length) {
            if (!this.isInLambdaSet(variables[k], lambdaSet) && this.belongsInLambdaSet(variables[k], grammar, lambdaSet)) {
                return variables[k];
            }
            ++k;
        }
        return null;
    }

    public HashSet<String> getCompleteLambdaSet(Grammar grammar) {
        HashSet<String> lambdaSet = this.getNewLambdaSet();
        while (this.areMoreVariablesToAddToLambdaSet(grammar, lambdaSet)) {
            String variable = this.getNewVariableThatBelongsInLambdaSet(grammar, lambdaSet);
            this.addVariableToLambdaSet(variable, lambdaSet);
        }
        return lambdaSet;
    }

    public Production[] getProductionsToAddForProduction(Production production, Set<String> lambdaSet) {
        Object[] start = new String[]{""};
        String rhs = production.getRHS();
        int i = 0;
        while (i < rhs.length()) {
            String v = rhs.substring(i, i + 1);
            if (lambdaSet.contains(v)) {
                String[] s = new String[start.length * 2];
                int j = 0;
                while (j < start.length) {
                    s[j] = String.valueOf(start[j]) + v;
                    s[j + start.length] = start[j];
                    ++j;
                }
                start = s;
            } else {
                int j = 0;
                while (j < start.length) {
                    int n = j++;
                    start[n] = String.valueOf(start[n]) + v;
                }
            }
            ++i;
        }
        Arrays.sort(start);
        ArrayList<Production> list = new ArrayList<Production>();
        String lhs = production.getLHS();
        int i2 = ((String)start[0]).length() == 0 ? 1 : 0;
        while (i2 < start.length) {
            list.add(new Production(lhs, (String)start[i2]));
            ++i2;
        }
        return list.toArray(new Production[0]);
    }

    public Production[] getProductionsToAddToGrammar(Grammar grammar, Set<String> lambdaSet) {
        ArrayList<Production> list = new ArrayList<Production>();
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            Production[] prods = this.getProductionsToAddForProduction(productions[k], lambdaSet);
            int j = 0;
            while (j < prods.length) {
                list.add(prods[j]);
                ++j;
            }
            ++k;
        }
        return list.toArray(new Production[0]);
    }

    public Production[] getNonLambdaProductions(Grammar grammar) {
        ProductionChecker pc = new ProductionChecker();
        ArrayList<Production> list = new ArrayList<Production>();
        Production[] productions = grammar.getProductions();
        int k = 0;
        while (k < productions.length) {
            if (!ProductionChecker.isLambdaProduction(productions[k])) {
                list.add(productions[k]);
            }
            ++k;
        }
        return list.toArray(new Production[0]);
    }

    public Grammar getLambdaProductionlessGrammar(Grammar grammar, Set<String> lambdaSet) {
        ContextFreeGrammar g = new ContextFreeGrammar();
        g.addProductions(this.getProductionsToAddToGrammar(grammar, lambdaSet));
        return g;
    }

    private boolean isNotReplacedByLambda(char ch, String comb) {
        int k = 0;
        while (k < comb.length()) {
            if (ch == comb.charAt(k)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private Production getProductionForCombination(Production production, String comb) {
        ProductionChecker pc = new ProductionChecker();
        String rhs = production.getRHS();
        StringBuffer buffer = new StringBuffer();
        int k = 0;
        while (k < rhs.length()) {
            char ch = rhs.charAt(k);
            if (ProductionChecker.isTerminal(ch) || this.isNotReplacedByLambda(ch, comb)) {
                buffer.append(ch);
            }
            ++k;
        }
        Production p = new Production(production.getLHS(), buffer.toString());
        return p;
    }

    private String getRepresentation(String binary, String[] variables) {
        StringBuffer buffer = new StringBuffer();
        int k = 0;
        while (k < binary.length()) {
            char ch = binary.charAt(k);
            if (ch == this.ONE_CHAR) {
                buffer.append(variables[k]);
            }
            ++k;
        }
        return buffer.toString();
    }

    private String pad(String binaryNum, int length) {
        int numZeros = length - binaryNum.length();
        int k = 0;
        while (k < numZeros) {
            binaryNum = this.ZERO.concat(binaryNum);
            ++k;
        }
        return binaryNum;
    }

    private String[] getCombinations(String[] variables) {
        ArrayList<String> list = new ArrayList<String>();
        int k = 0;
        while (k < (int)Math.pow(2.0, variables.length)) {
            String comb = this.pad(Integer.toBinaryString(k), variables.length);
            list.add(this.getRepresentation(comb, variables));
            ++k;
        }
        return list.toArray(new String[0]);
    }
}

