/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import file.ParseException;
import file.xml.AbstractTransducer;
import java.io.Serializable;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import regular.RegularExpression;

public class RETransducer
extends AbstractTransducer {
    public static final String EXPRESSION_NAME = "expression";
    private static final String COMMENT_EXPRESSION = "The regular expression.";

    @Override
    public String getType() {
        return "re";
    }

    @Override
    public Serializable fromDOM(Document document) {
        Map<String, String> e2t = RETransducer.elementsToText(document.getDocumentElement());
        String expression = e2t.get(EXPRESSION_NAME);
        if (expression == null) {
            if (e2t.containsKey(EXPRESSION_NAME)) {
                throw new ParseException("Regular expression structure has no expression tag!");
            }
            expression = "";
        }
        return new RegularExpression(expression);
    }

    @Override
    public Document toDOM(Serializable structure) {
        RegularExpression re = (RegularExpression)structure;
        Document doc = this.newEmptyDocument();
        Element se = doc.getDocumentElement();
        se.appendChild(RETransducer.createComment(doc, COMMENT_EXPRESSION));
        se.appendChild(RETransducer.createElement(doc, EXPRESSION_NAME, null, re.asString()));
        return doc;
    }
}

