/*
 * Decompiled with CFR 0.152.
 */
package file;

import file.Codec;
import file.EncodeException;
import file.Encoder;
import file.ParseException;
import file.XMLCodec;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;

public class SerializedCodec
extends Codec {
    private XMLCodec xmlcodec;

    public SerializedCodec(XMLCodec xmlcodec) {
        this.xmlcodec = xmlcodec;
    }

    @Override
    public Serializable decode(File file, Map<?, ?> parameters) {
        Serializable object = null;
        try {
            ObjectInputStream stream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            object = (Serializable)stream.readObject();
            stream.close();
        }
        catch (IOException e) {
            throw new ParseException("Could not open file to read!");
        }
        catch (ClassCastException e) {
            throw new ParseException("Bad Class Read!");
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("Unrecognized Class Read!");
        }
        return object;
    }

    @Override
    public File encode(Serializable structure, File file, Map<?, ?> parameters) {
        try {
            ObjectOutputStream stream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            stream.writeObject(structure);
            stream.flush();
            stream.close();
            return file;
        }
        catch (NotSerializableException e) {
            throw new EncodeException("Object Not Serializable");
        }
        catch (IOException e) {
            throw new EncodeException("Could not open file to write!");
        }
    }

    @Override
    public boolean canEncode(Serializable structure) {
        return false;
    }

    @Override
    public String getDescription() {
        return "JFLAP 4 Beta File";
    }

    @Override
    public Encoder correspondingEncoder() {
        return this.xmlcodec;
    }
}

