/*
 * Decompiled with CFR 0.152.
 */
package automata.pda;

import automata.State;
import automata.Transition;
import automata.pda.PushdownAutomaton;
import gui.environment.Universe;

public class PDATransition
extends Transition {
    private static final long serialVersionUID = 1L;
    protected String myInputToRead;
    protected String myStringToPop;
    protected String myStringToPush;

    public PDATransition(State from, State to, String inputToRead, String stringToPop, String stringToPush) {
        super(from, to);
        this.setInputToRead(inputToRead);
        this.setStringToPop(stringToPop);
        this.setStringToPush(stringToPush);
    }

    @Override
    public Transition copy(State from, State to) {
        return new PDATransition(from, to, this.getInputToRead(), this.getStringToPop(), this.getStringToPush());
    }

    public String getInputToRead() {
        return this.myInputToRead;
    }

    protected void setInputToRead(String inputToRead) {
        this.myInputToRead = inputToRead;
    }

    public String getStringToPop() {
        return this.myStringToPop;
    }

    protected void setStringToPop(String stringToPop) {
        PushdownAutomaton myPDA = (PushdownAutomaton)this.getAutomaton();
        if (myPDA.singleInputPDA && stringToPop.length() > 1) {
            throw new IllegalArgumentException("Pop string must have no more than one character!");
        }
        this.myStringToPop = stringToPop;
    }

    public String getStringToPush() {
        return this.myStringToPush;
    }

    protected void setStringToPush(String stringToPush) {
        PushdownAutomaton myPDA = (PushdownAutomaton)this.getAutomaton();
        if (myPDA.singleInputPDA && stringToPush.length() > 1) {
            throw new IllegalArgumentException("Push string must have no more than one character!");
        }
        this.myStringToPush = stringToPush;
    }

    @Override
    public String getDescription() {
        String toPush;
        String toPop;
        String input = this.getInputToRead();
        if (input.length() == 0) {
            input = Universe.curProfile.getEmptyString();
        }
        if ((toPop = this.getStringToPop()).length() == 0) {
            toPop = Universe.curProfile.getEmptyString();
        }
        if ((toPush = this.getStringToPush()).length() == 0) {
            toPush = Universe.curProfile.getEmptyString();
        }
        return String.valueOf(input) + " , " + toPop + " ; " + toPush;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.myInputToRead.hashCode() ^ this.myStringToPop.hashCode() ^ this.myStringToPush.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        try {
            PDATransition t = (PDATransition)object;
            return super.equals(object) && this.myInputToRead.equals(t.myInputToRead) && this.myStringToPop.equals(t.myStringToPop) && this.myStringToPush.equals(t.myStringToPush);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ": \"" + this.getInputToRead() + "\"" + ": \"" + this.getStringToPop() + "\"" + ": \"" + this.getStringToPush() + "\"";
    }
}

