/*
 * Decompiled with CFR 0.152.
 */
package automata.pda;

import automata.Automaton;
import automata.Configuration;
import automata.State;
import automata.pda.CharacterStack;

public class PDAConfiguration
extends Configuration {
    protected int myAcceptance;
    protected static final int EMPTY_STACK = 0;
    protected static final int FINAL_STATE = 1;
    protected String myInput;
    protected String myUnprocessedInput;
    protected CharacterStack myStack;

    public PDAConfiguration(State state, PDAConfiguration parent, String input, String unprocessed, CharacterStack stack, int acceptance) {
        super(state, parent);
        this.myInput = input;
        this.myUnprocessedInput = unprocessed;
        this.myStack = stack;
        this.myAcceptance = acceptance;
    }

    public String getInput() {
        return this.myInput;
    }

    public String getUnprocessedInput() {
        return this.myUnprocessedInput;
    }

    public void setUnprocessedInput(String input) {
        this.myUnprocessedInput = input;
    }

    public CharacterStack getStack() {
        return this.myStack;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " INPUT: " + this.getUnprocessedInput() + " STACK: " + this.myStack.toString();
    }

    @Override
    public boolean isAccept() {
        if (this.myAcceptance == 1) {
            if (this.getUnprocessedInput().length() != 0) {
                return false;
            }
            State s = this.getCurrentState();
            Automaton a = s.getAutomaton();
            return a.isFinalState(s);
        }
        if (this.myAcceptance == 0) {
            CharacterStack stack = this.getStack();
            if (this.getUnprocessedInput() == "" && stack.height() == 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object configuration) {
        if (configuration == this) {
            return true;
        }
        try {
            return super.equals(configuration) && this.myUnprocessedInput.equals(((PDAConfiguration)configuration).myUnprocessedInput) && this.myStack.equals(((PDAConfiguration)configuration).myStack);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.myStack.hashCode() ^ this.myUnprocessedInput.hashCode();
    }
}

