/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.AlphabetRetriever;
import automata.Automaton;
import automata.AutomatonChecker;
import automata.ClosureTaker;
import automata.State;
import automata.StatePlacer;
import automata.Transition;
import automata.fsa.FSAAlphabetRetriever;
import automata.fsa.FSALabelHandler;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;

public class NFAToDFA {
    public State createInitialState(Automaton nfa, Automaton dfa) {
        State initialState = nfa.getInitialState();
        State[] initialClosure = ClosureTaker.getClosure(initialState, nfa);
        State state = this.createStateWithStates(dfa, initialClosure, nfa);
        dfa.setInitialState(state);
        return state;
    }

    public boolean hasFinalState(State[] states, Automaton automaton) {
        int k = 0;
        while (k < states.length) {
            if (automaton.isFinalState(states[k])) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public State[] getStatesForState(State state, Automaton automaton) {
        if (state.getLabel() == null) {
            return new State[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(state.getLabel(), " \t\n\r\f,q");
        ArrayList<State> states = new ArrayList<State>();
        while (tokenizer.hasMoreTokens()) {
            states.add(automaton.getStateWithID(Integer.parseInt(tokenizer.nextToken())));
        }
        return states.toArray(new State[0]);
    }

    public String getStringForStates(State[] states) {
        StringBuffer buffer = new StringBuffer();
        int k = 0;
        while (k < states.length - 1) {
            buffer.append(Integer.toString(states[k].getID()));
            buffer.append(",");
            ++k;
        }
        buffer.append(Integer.toString(states[states.length - 1].getID()));
        return buffer.toString();
    }

    public State[] getStatesOnTerminal(String terminal, State[] states, Automaton automaton) {
        ArrayList<State> list = new ArrayList<State>();
        int k = 0;
        while (k < states.length) {
            State state = states[k];
            Transition[] transitions = automaton.getTransitionsFromState(state);
            int i = 0;
            while (i < transitions.length) {
                FSATransition transition = (FSATransition)transitions[i];
                if (transition.getLabel().equals(terminal)) {
                    State toState = transition.getToState();
                    State[] closure = ClosureTaker.getClosure(toState, automaton);
                    int j = 0;
                    while (j < closure.length) {
                        if (!list.contains(closure[j])) {
                            list.add(closure[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++k;
        }
        return list.toArray(new State[0]);
    }

    private boolean containsState(State state, State[] states) {
        int k = 0;
        while (k < states.length) {
            if (states[k] == state) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public boolean containSameStates(State[] states1, State[] states2) {
        int len1 = states1.length;
        int len2 = states2.length;
        if (len1 != len2) {
            return false;
        }
        Arrays.sort(states1, new Comparator<State>(){

            @Override
            public int compare(State s, State t) {
                return s.hashCode() - t.hashCode();
            }
        });
        Arrays.sort(states2, new Comparator<State>(){

            @Override
            public int compare(State s, State t) {
                return s.hashCode() - t.hashCode();
            }
        });
        int k = 0;
        while (k < states1.length) {
            if (states1[k] != states2[k]) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public State getStateForStates(State[] states, Automaton dfa, Automaton nfa) {
        State[] dfaStates = dfa.getStates();
        int k = 0;
        while (k < dfaStates.length) {
            State[] nfaStates = this.getStatesForState(dfaStates[k], nfa);
            if (this.containSameStates(nfaStates, states)) {
                return dfaStates[k];
            }
            ++k;
        }
        return null;
    }

    public ArrayList<State> expandState(State state, Automaton nfa, Automaton dfa) {
        ArrayList<State> list = new ArrayList<State>();
        FSAAlphabetRetriever far = new FSAAlphabetRetriever();
        String[] alphabet = ((AlphabetRetriever)far).getAlphabet(nfa);
        int k = 0;
        while (k < alphabet.length) {
            State[] states = this.getStatesOnTerminal(alphabet[k], this.getStatesForState(state, nfa), nfa);
            if (states.length > 0) {
                State toState = this.getStateForStates(states, dfa, nfa);
                if (toState == null) {
                    toState = this.createStateWithStates(dfa, states, nfa);
                    list.add(toState);
                }
                FSATransition transition = new FSATransition(state, toState, alphabet[k]);
                dfa.addTransition(transition);
            }
            ++k;
        }
        return list;
    }

    public State createStateWithStates(Automaton dfa, State[] states, Automaton nfa) {
        StatePlacer sp = new StatePlacer();
        State state = dfa.createState(sp.getPointForState(dfa));
        state.setLabel(this.getStringForStates(states));
        if (this.hasFinalState(states, nfa)) {
            dfa.addFinalState(state);
        }
        return state;
    }

    public FiniteStateAutomaton convertToDFA(Automaton automaton) {
        AutomatonChecker ac = new AutomatonChecker();
        if (!ac.isNFA(automaton)) {
            return (FiniteStateAutomaton)automaton.clone();
        }
        if (FSALabelHandler.hasMultipleCharacterLabels(automaton)) {
            FSALabelHandler.removeMultipleCharacterLabelsFromAutomaton(automaton);
        }
        FiniteStateAutomaton dfa = new FiniteStateAutomaton();
        State initialState = this.createInitialState(automaton, dfa);
        ArrayList<State> list = new ArrayList<State>();
        list.add(initialState);
        while (!list.isEmpty()) {
            ArrayList<State> statesToExpand = new ArrayList<State>();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                State state = (State)it.next();
                statesToExpand.addAll(this.expandState(state, automaton, dfa));
                it.remove();
            }
            list.addAll(statesToExpand);
        }
        return dfa;
    }
}

