/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.Automaton;
import automata.State;
import automata.StatePlacer;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import gui.environment.Universe;
import java.util.ArrayList;
import regular.Discretizer;

public class FSAToRegularExpressionConverter {
    public static final String EMPTY = "\u00f8";
    public static final String LAMBDA_DISPLAY = Universe.curProfile.getEmptyString();
    public static final String LAMBDA = "";
    public static final String KLEENE_STAR = "*";
    public static final String OR = "+";
    public static final String RIGHT_PAREN = ")";
    public static final String LEFT_PAREN = "(";

    private FSAToRegularExpressionConverter() {
    }

    public static boolean isConvertable(Automaton automaton) {
        if (!(automaton instanceof FiniteStateAutomaton)) {
            return false;
        }
        State[] finalStates = automaton.getFinalStates();
        if (finalStates.length != 1) {
            return false;
        }
        State initialState = automaton.getInitialState();
        return finalStates[0] != initialState;
    }

    public static boolean areRemovableStates(Automaton automaton) {
        State[] states = automaton.getStates();
        int k = 0;
        while (k < states.length) {
            if (FSAToRegularExpressionConverter.isRemovable(states[k], automaton)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static boolean isRemovable(State state, Automaton automaton) {
        State[] finalStates = automaton.getFinalStates();
        State finalState = finalStates[0];
        State initialState = automaton.getInitialState();
        return state != finalState && state != initialState;
    }

    public static Transition getTransitionForExpression(int p, int q, String expression, Automaton automaton) {
        State fromState = automaton.getStateWithID(p);
        State toState = automaton.getStateWithID(q);
        FSATransition transition = new FSATransition(fromState, toState, expression);
        return transition;
    }

    public static String getExpressionBetweenStates(State fromState, State toState, Automaton automaton) {
        Transition[] transitions = automaton.getTransitionsFromStateToState(fromState, toState);
        FSATransition trans = (FSATransition)transitions[0];
        return trans.getLabel();
    }

    public static String getExpression(int p, int q, int k, Automaton automaton) {
        State fromState = automaton.getStateWithID(p);
        State toState = automaton.getStateWithID(q);
        State removeState = automaton.getStateWithID(k);
        String pq = FSAToRegularExpressionConverter.getExpressionBetweenStates(fromState, toState, automaton);
        String pk = FSAToRegularExpressionConverter.getExpressionBetweenStates(fromState, removeState, automaton);
        String kk = FSAToRegularExpressionConverter.getExpressionBetweenStates(removeState, removeState, automaton);
        String kq = FSAToRegularExpressionConverter.getExpressionBetweenStates(removeState, toState, automaton);
        String temp1 = FSAToRegularExpressionConverter.star(kk);
        String temp2 = FSAToRegularExpressionConverter.concatenate(pk, temp1);
        String temp3 = FSAToRegularExpressionConverter.concatenate(temp2, kq);
        String label = FSAToRegularExpressionConverter.or(pq, temp3);
        return label;
    }

    public static String concatenate(String r1, String r2) {
        if (r1.equals(EMPTY) || r2.equals(EMPTY)) {
            return EMPTY;
        }
        if (r1.equals(LAMBDA)) {
            return r2;
        }
        if (r2.equals(LAMBDA)) {
            return r1;
        }
        if (Discretizer.or(r1).length > 1) {
            r1 = FSAToRegularExpressionConverter.addParen(r1);
        }
        if (Discretizer.or(r2).length > 1) {
            r2 = FSAToRegularExpressionConverter.addParen(r2);
        }
        return String.valueOf(r1) + r2;
    }

    public static String star(String r1) {
        if (r1.equals(EMPTY) || r1.equals(LAMBDA)) {
            return LAMBDA;
        }
        if (Discretizer.or(r1).length > 1 || Discretizer.cat(r1).length > 1) {
            r1 = FSAToRegularExpressionConverter.addParen(r1);
        } else if (r1.endsWith(KLEENE_STAR)) {
            return r1;
        }
        return String.valueOf(r1) + KLEENE_STAR;
    }

    public static String or(String r1, String r2) {
        if (r1.equals(EMPTY)) {
            return r2;
        }
        if (r2.equals(EMPTY)) {
            return r1;
        }
        if (r1.equals(LAMBDA) && r2.equals(LAMBDA)) {
            return LAMBDA;
        }
        if (r1.equals(LAMBDA)) {
            r1 = LAMBDA_DISPLAY;
        }
        if (r2.equals(LAMBDA)) {
            r2 = LAMBDA_DISPLAY;
        }
        return String.valueOf(r1) + OR + r2;
    }

    public static void removeState(State state, Transition[] transitions, Automaton automaton) {
        Transition[] oldTransitions = automaton.getTransitions();
        int k = 0;
        while (k < oldTransitions.length) {
            automaton.removeTransition(oldTransitions[k]);
            ++k;
        }
        automaton.removeState(state);
        int i = 0;
        while (i < transitions.length) {
            automaton.addTransition(transitions[i]);
            ++i;
        }
    }

    public static Transition[] getTransitionsForRemoveState(State state, Automaton automaton) {
        if (!FSAToRegularExpressionConverter.isRemovable(state, automaton)) {
            return null;
        }
        ArrayList<Transition> list = new ArrayList<Transition>();
        int k = state.getID();
        State[] states = automaton.getStates();
        int i = 0;
        while (i < states.length) {
            int p = states[i].getID();
            if (p != k) {
                int j = 0;
                while (j < states.length) {
                    int q = states[j].getID();
                    if (q != k) {
                        String exp = FSAToRegularExpressionConverter.getExpression(p, q, k, automaton);
                        list.add(FSAToRegularExpressionConverter.getTransitionForExpression(p, q, exp, automaton));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new Transition[0]);
    }

    public static FSATransition addTransitionOnEmptySet(State fromState, State toState, Automaton automaton) {
        FSATransition t = new FSATransition(fromState, toState, EMPTY);
        automaton.addTransition(t);
        return t;
    }

    public static FSATransition combineToSingleTransition(State fromState, State toState, Transition[] transitions, Automaton automaton) {
        String label = ((FSATransition)transitions[0]).getDescription();
        automaton.removeTransition(transitions[0]);
        int i = 1;
        while (i < transitions.length) {
            label = FSAToRegularExpressionConverter.or(label, ((FSATransition)transitions[i]).getDescription());
            automaton.removeTransition(transitions[i]);
            ++i;
        }
        FSATransition t = new FSATransition(fromState, toState, label);
        automaton.addTransition(t);
        return t;
    }

    public static void getSingleFinalState(Automaton automaton) {
        StatePlacer sp = new StatePlacer();
        State finalState = automaton.createState(sp.getPointForState(automaton));
        State[] finalStates = automaton.getFinalStates();
        int k = 0;
        while (k < finalStates.length) {
            State state = finalStates[k];
            automaton.addTransition(new FSATransition(state, finalState, LAMBDA));
            automaton.removeFinalState(state);
            ++k;
        }
        automaton.addFinalState(finalState);
    }

    public static void convertToSimpleAutomaton(Automaton automaton) {
        if (!FSAToRegularExpressionConverter.isConvertable(automaton)) {
            FSAToRegularExpressionConverter.getSingleFinalState(automaton);
        }
        State[] states = automaton.getStates();
        int k = 0;
        while (k < states.length) {
            int j = 0;
            while (j < states.length) {
                Transition[] transitions = automaton.getTransitionsFromStateToState(states[k], states[j]);
                if (transitions.length == 0) {
                    FSAToRegularExpressionConverter.addTransitionOnEmptySet(states[k], states[j], automaton);
                }
                if (transitions.length > 1) {
                    FSAToRegularExpressionConverter.combineToSingleTransition(states[k], states[j], transitions, automaton);
                }
                ++j;
            }
            ++k;
        }
    }

    public static void convertToGTG(Automaton automaton) {
        State[] finalStates = automaton.getFinalStates();
        State finalState = finalStates[0];
        State initialState = automaton.getInitialState();
        State[] states = automaton.getStates();
        int k = 0;
        while (k < states.length) {
            State state = states[k];
            if (state != finalState && state != initialState) {
                Transition[] transitions = FSAToRegularExpressionConverter.getTransitionsForRemoveState(state, automaton);
                FSAToRegularExpressionConverter.removeState(state, transitions, automaton);
            }
            ++k;
        }
    }

    public static boolean isSingleCharacter(String word) {
        if (word.length() != 1) {
            return false;
        }
        char ch = word.charAt(0);
        return Character.isLetter(ch);
    }

    public static boolean needsParens(String word) {
        int k = 0;
        while (k < word.length()) {
            char ch = word.charAt(k);
            if (ch == '+') {
                return true;
            }
            ++k;
        }
        return false;
    }

    public static String addParen(String word) {
        return LEFT_PAREN + word + RIGHT_PAREN;
    }

    public static String getExp(String word) {
        if (word.equals(LAMBDA)) {
            return "lambda";
        }
        if (word.equals(EMPTY)) {
            return "empty";
        }
        return word;
    }

    public static String getFinalExpression(String ii, String ij, String jj, String ji) {
        String temp = FSAToRegularExpressionConverter.concatenate(FSAToRegularExpressionConverter.star(ii), FSAToRegularExpressionConverter.concatenate(ij, FSAToRegularExpressionConverter.concatenate(FSAToRegularExpressionConverter.star(jj), ji)));
        String temp2 = FSAToRegularExpressionConverter.concatenate(FSAToRegularExpressionConverter.star(ii), FSAToRegularExpressionConverter.concatenate(ij, FSAToRegularExpressionConverter.star(jj)));
        String expression = FSAToRegularExpressionConverter.concatenate(FSAToRegularExpressionConverter.star(temp), temp2);
        return expression;
    }

    public static String getII(Automaton automaton) {
        State initialState = automaton.getInitialState();
        return FSAToRegularExpressionConverter.getExpressionBetweenStates(initialState, initialState, automaton);
    }

    public static String getIJ(Automaton automaton) {
        State initialState = automaton.getInitialState();
        State[] finalStates = automaton.getFinalStates();
        State finalState = finalStates[0];
        return FSAToRegularExpressionConverter.getExpressionBetweenStates(initialState, finalState, automaton);
    }

    public static String getJJ(Automaton automaton) {
        State[] finalStates = automaton.getFinalStates();
        State finalState = finalStates[0];
        return FSAToRegularExpressionConverter.getExpressionBetweenStates(finalState, finalState, automaton);
    }

    public static String getJI(Automaton automaton) {
        State initialState = automaton.getInitialState();
        State[] finalStates = automaton.getFinalStates();
        State finalState = finalStates[0];
        return FSAToRegularExpressionConverter.getExpressionBetweenStates(finalState, initialState, automaton);
    }

    public static String getExpressionFromGTG(Automaton automaton) {
        String ii = FSAToRegularExpressionConverter.getII(automaton);
        String ij = FSAToRegularExpressionConverter.getIJ(automaton);
        String jj = FSAToRegularExpressionConverter.getJJ(automaton);
        String ji = FSAToRegularExpressionConverter.getJI(automaton);
        return FSAToRegularExpressionConverter.getFinalExpression(ii, ij, jj, ji);
    }

    public static String convertToRegularExpression(Automaton automaton) {
        if (!FSAToRegularExpressionConverter.isConvertable(automaton)) {
            return null;
        }
        FSAToRegularExpressionConverter.convertToGTG(automaton);
        return FSAToRegularExpressionConverter.getExpressionFromGTG(automaton);
    }
}

