/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.Automaton;
import automata.ClosureTaker;
import automata.Configuration;
import automata.State;
import automata.Transition;
import automata.fsa.FSAConfiguration;
import automata.fsa.FSAStepByStateSimulator;
import automata.fsa.FSATransition;
import debug.EDebug;
import java.util.ArrayList;
import java.util.HashSet;

public class FSAStepWithClosureSimulator
extends FSAStepByStateSimulator {
    public FSAStepWithClosureSimulator(Automaton automaton) {
        super(automaton);
    }

    @Override
    public Configuration[] getInitialConfigurations(String input) {
        State init = this.myAutomaton.getInitialState();
        State[] closure = ClosureTaker.getClosure(init, this.myAutomaton);
        Configuration[] configs = new Configuration[closure.length];
        int k = 0;
        while (k < closure.length) {
            configs[k] = new FSAConfiguration(closure[k], null, input, input);
            ++k;
        }
        return configs;
    }

    @Override
    public ArrayList<Configuration> stepConfiguration(Configuration config) {
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        FSAConfiguration configuration = (FSAConfiguration)config;
        String unprocessedInput = configuration.getUnprocessedInput();
        String totalInput = configuration.getInput();
        State currentState = configuration.getCurrentState();
        Transition[] transitions = this.myAutomaton.getTransitionsFromState(currentState);
        int k = 0;
        while (k < transitions.length) {
            FSAConfiguration configurationToAdd;
            FSATransition transition = (FSATransition)transitions[k];
            String transLabel = transition.getLabel();
            HashSet<String> trange = new HashSet<String>();
            if (transLabel.contains("[")) {
                int i = transLabel.charAt(transLabel.indexOf("[") + 1);
                while (i <= transLabel.charAt(transLabel.indexOf("[") + 3)) {
                    trange.add(Character.toString((char)i));
                    EDebug.print(Character.toString((char)i));
                    ++i;
                }
                if (transLabel.length() > 0) {
                    for (String element : trange) {
                        if (!unprocessedInput.startsWith(element)) continue;
                        String input = "";
                        if (element.length() < unprocessedInput.length()) {
                            input = unprocessedInput.substring(element.length());
                        }
                        State toState = transition.getToState();
                        configurationToAdd = new FSAConfiguration(toState, configuration, totalInput, input);
                        list.add(configurationToAdd);
                    }
                }
            } else if (transLabel.length() > 0 && unprocessedInput.startsWith(transLabel)) {
                String input = "";
                if (transLabel.length() < unprocessedInput.length()) {
                    input = unprocessedInput.substring(transLabel.length());
                }
                State toState = transition.getToState();
                State[] closure = ClosureTaker.getClosure(toState, this.myAutomaton);
                int i = 0;
                while (i < closure.length) {
                    configurationToAdd = new FSAConfiguration(closure[i], configuration, totalInput, input);
                    list.add(configurationToAdd);
                    ++i;
                }
            }
            ++k;
        }
        return list;
    }
}

