/*
 * Decompiled with CFR 0.152.
 */
package automata;

import gui.editor.DeleteTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.environment.AutomatonEnvironment;
import gui.viewer.AutomatonPane;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTextArea;

public class Note
extends JTextArea {
    private static final long serialVersionUID = 1L;
    private Point myAutoPoint = null;
    public boolean moving = false;
    protected Point initialPointState;
    protected Point initialPointClick;
    protected AutomatonPane myView;
    public Point myViewPoint = new Point(0, 0);

    public Note(Point p, String message) {
        this.setLocationManually(p);
        this.setText(message);
    }

    public Note(String message) {
        this.setText(message);
    }

    public Note(Point point) {
        this.setLocationManually(point);
    }

    public void setView(AutomatonPane view) {
        this.myView = view;
    }

    public void initializeForView(AutomatonPane view) {
        this.myView = view;
        this.setLocationManually(this.myAutoPoint);
        this.setDisabledTextColor(Color.BLACK);
        this.setBackground(new Color(255, 255, 150));
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    return;
                }
                if (!((Note)e.getSource()).isEditable()) {
                    int diffX = e.getPoint().x - Note.this.initialPointClick.x;
                    int diffY = e.getPoint().y - Note.this.initialPointClick.y;
                    int nowAtX = Note.this.initialPointState.x + diffX;
                    int nowAtY = Note.this.initialPointState.y + diffY;
                    ((Note)e.getSource()).setLocationManually(new Point(nowAtX, nowAtY));
                    Note.this.initialPointState = new Point(((Note)e.getSource()).getAutoPoint());
                }
                Note.this.myView.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Note.this.myView.getDrawer().getAutomaton().getEnvironmentFrame() != null) {
                    ((AutomatonEnvironment)Note.this.myView.getDrawer().getAutomaton().getEnvironmentFrame().getEnvironment()).saveStatus();
                }
                ((Note)e.getComponent()).setEnabled(true);
                ((Note)e.getComponent()).setEditable(true);
                ((Note)e.getComponent()).setCaretColor(null);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (Note.this.myView.getDrawer().getAutomaton().getEnvironmentFrame() != null) {
                    ((AutomatonEnvironment)Note.this.myView.getDrawer().getAutomaton().getEnvironmentFrame().getEnvironment()).saveStatus();
                    ((AutomatonEnvironment)Note.this.myView.getDrawer().getAutomaton().getEnvironmentFrame().getEnvironment()).setDirty();
                }
                Note.this.initialPointState = new Point(((Note)e.getSource()).getAutoPoint());
                Note.this.initialPointClick = new Point(e.getPoint().x, e.getPoint().y);
                EditorPane pane = Note.this.myView.getCreator();
                Tool curTool = pane.getToolBar().getCurrentTool();
                if (curTool instanceof DeleteTool) {
                    Note.this.myView.remove((Note)e.getSource());
                    Note.this.myView.getDrawer().getAutomaton().deleteNote((Note)e.getSource());
                    Note.this.myView.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.myView.add(this);
        this.setEnabled(true);
        this.setEditable(true);
        this.setCaretColor(null);
        this.setSelectionStart(0);
        this.setSelectionEnd(this.getColumnWidth());
        this.requestFocus();
    }

    public Point getAutoPoint() {
        return this.myAutoPoint;
    }

    public AutomatonPane getView() {
        return this.myView;
    }

    public void setLocationManually(Point point) {
        this.moving = true;
        this.myAutoPoint = point;
        if (this.myView != null) {
            this.setLocation(this.myView.transformFromAutomatonToView(point));
        }
    }

    @Override
    public void setLocation(Point p) {
        if (this.moving && this.myView != null) {
            this.myViewPoint = p;
            super.setLocation(p);
        }
    }

    @Override
    public void setLocation(int x, int y) {
        if (this.moving) {
            super.setLocation(x, y);
        }
        this.moving = false;
    }

    public void updateView() {
        this.setLocationManually(this.myAutoPoint);
    }

    public int specialHash() {
        return this.myAutoPoint == null ? -1 : this.myAutoPoint.hashCode() + this.getText().hashCode();
    }
}

