/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.IncompatibleTransitionException;
import automata.Note;
import automata.State;
import automata.Transition;
import automata.event.AutomataNoteEvent;
import automata.event.AutomataNoteListener;
import automata.event.AutomataStateEvent;
import automata.event.AutomataStateListener;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import automata.mealy.MooreMachine;
import gui.environment.EnvironmentFrame;
import gui.viewer.AutomatonPane;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Automaton
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String fileName = "";
    private EnvironmentFrame myEnvFrame = null;
    public Set<State> states;
    private State[] cachedStates = null;
    private Transition[] cachedTransitions = null;
    private State[] cachedFinalStates = null;
    public Set<State> finalStates;
    protected State initialState = null;
    protected Set<Object> transitions;
    private HashMap<State, LinkedList<Transition>> transitionFromStateMap = new HashMap();
    private HashMap<State, LinkedList<Transition>> transitionToStateMap = new HashMap();
    private HashMap<State, Transition[]> transitionArrayFromStateMap = new HashMap();
    private HashMap<State, Transition[]> transitionArrayToStateMap = new HashMap();
    private ArrayList<Note> myNotes = new ArrayList();
    public Color myColor = new Color(255, 255, 150);
    private transient HashSet<AutomataTransitionListener> transitionListeners = new HashSet();
    private transient HashSet<AutomataStateListener> stateListeners = new HashSet();
    private transient HashSet<AutomataNoteListener> noteListeners = new HashSet();

    public Automaton() {
        this.states = new HashSet<State>();
        this.transitions = new HashSet<Object>();
        this.finalStates = new HashSet<State>();
    }

    public Object clone() {
        Automaton a;
        try {
            a = (Automaton)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            System.err.println("Warning: clone of automaton failed!");
            return null;
        }
        a.setEnvironmentFrame(this.getEnvironmentFrame());
        HashMap<State, State> map = new HashMap<State, State>();
        for (State state : this.states) {
            State nstate = new State(state.getID(), new Point(state.getPoint()), a);
            nstate.setLabel(state.getLabel());
            nstate.setName(state.getName());
            map.put(state, nstate);
            a.addState(nstate);
            if (!(this instanceof MooreMachine)) continue;
            MooreMachine m = (MooreMachine)a;
            m.setOutput(nstate, ((MooreMachine)this).getOutput(state));
        }
        for (State state : this.finalStates) {
            a.addFinalState((State)map.get(state));
        }
        a.setInitialState((State)map.get(this.getInitialState()));
        for (State state : this.states) {
            Transition[] ts = this.getTransitionsFromState(state);
            State from = (State)map.get(state);
            int i = 0;
            while (i < ts.length) {
                State to = (State)map.get(ts[i].getToState());
                Transition toBeAdded = (Transition)ts[i].clone();
                toBeAdded.setFromState(from);
                toBeAdded.setToState(to);
                a.addTransition(toBeAdded);
                ++i;
            }
        }
        int k = 0;
        while (k < this.getNotes().size()) {
            Note curNote = this.getNotes().get(k);
            a.addNote(new Note(curNote.getAutoPoint(), curNote.getText()));
            a.getNotes().get(k).setView(curNote.getView());
            ++k;
        }
        return a;
    }

    public static void become(Automaton dest, Automaton src) {
        dest.clear();
        HashMap<State, State> map = new HashMap<State, State>();
        for (State state : src.states) {
            State nstate = new State(state.getID(), new Point(state.getPoint()), dest);
            nstate.setLabel(state.getLabel());
            nstate.setName(state.getName());
            map.put(state, nstate);
            dest.addState(nstate);
            if (!(src instanceof MooreMachine)) continue;
            MooreMachine m = (MooreMachine)dest;
            m.setOutput(nstate, ((MooreMachine)src).getOutput(state));
        }
        for (State state : src.finalStates) {
            dest.addFinalState((State)map.get(state));
        }
        dest.setInitialState((State)map.get(src.getInitialState()));
        for (State state : src.states) {
            Transition[] ts = src.getTransitionsFromState(state);
            State from = (State)map.get(state);
            int i = 0;
            while (i < ts.length) {
                State to = (State)map.get(ts[i].getToState());
                Transition toBeAdded = (Transition)ts[i].clone();
                toBeAdded.setFromState(from);
                toBeAdded.setToState(to);
                dest.addTransition(toBeAdded);
                ++i;
            }
        }
        int k = 0;
        while (k < src.getNotes().size()) {
            Note curNote = src.getNotes().get(k);
            dest.addNote(new Note(curNote.getAutoPoint(), curNote.getText()));
            dest.getNotes().get(k).initializeForView(curNote.getView());
            ++k;
        }
        dest.setEnvironmentFrame(src.getEnvironmentFrame());
    }

    public Transition[] getTransitionsFromState(State from) {
        Transition[] toReturn = this.transitionArrayFromStateMap.get(from);
        if (toReturn == null) {
            List list = this.transitionFromStateMap.get(from);
            toReturn = list.toArray(new Transition[0]);
            this.transitionArrayFromStateMap.put(from, toReturn);
        }
        return toReturn;
    }

    public Transition[] getTransitionsToState(State to) {
        Transition[] toReturn = this.transitionArrayToStateMap.get(to);
        if (toReturn == null) {
            List list = this.transitionToStateMap.get(to);
            toReturn = list.toArray(new Transition[0]);
            this.transitionArrayToStateMap.put(to, toReturn);
        }
        return toReturn;
    }

    public Transition[] getTransitionsFromStateToState(State from, State to) {
        Transition[] t = this.getTransitionsFromState(from);
        ArrayList<Transition> list = new ArrayList<Transition>();
        int i = 0;
        while (i < t.length) {
            if (t[i].getToState() == to) {
                list.add(t[i]);
            }
            ++i;
        }
        return list.toArray(new Transition[0]);
    }

    public Transition[] getTransitions() {
        if (this.cachedTransitions == null) {
            this.cachedTransitions = this.transitions.toArray(new Transition[0]);
        }
        return this.cachedTransitions;
    }

    public void addTransition(Transition trans) {
        if (!this.getTransitionClass().isInstance(trans) || trans == null) {
            throw new IncompatibleTransitionException();
        }
        if (this.transitions.contains(trans)) {
            return;
        }
        if (trans.getToState() == null || trans.getFromState() == null) {
            return;
        }
        this.transitions.add(trans);
        if (this.transitionFromStateMap == null) {
            this.transitionFromStateMap = new HashMap();
        }
        List list = this.transitionFromStateMap.get(trans.getFromState());
        list.add(trans);
        if (this.transitionToStateMap == null) {
            this.transitionToStateMap = new HashMap();
        }
        list = this.transitionToStateMap.get(trans.getToState());
        list.add(trans);
        this.transitionArrayFromStateMap.remove(trans.getFromState());
        this.transitionArrayToStateMap.remove(trans.getToState());
        this.cachedTransitions = null;
        this.distributeTransitionEvent(new AutomataTransitionEvent(this, trans, true, false));
    }

    public void replaceTransition(Transition oldTrans, Transition newTrans) {
        if (!this.getTransitionClass().isInstance(newTrans)) {
            throw new IncompatibleTransitionException();
        }
        if (oldTrans.equals(newTrans)) {
            return;
        }
        if (this.transitions.contains(newTrans)) {
            this.removeTransition(oldTrans);
            return;
        }
        if (!this.transitions.remove(oldTrans)) {
            throw new IllegalArgumentException("Replacing transition that not already in the automaton!");
        }
        this.transitions.add(newTrans);
        List list = this.transitionFromStateMap.get(oldTrans.getFromState());
        list.set(list.indexOf(oldTrans), newTrans);
        list = this.transitionToStateMap.get(oldTrans.getToState());
        list.set(list.indexOf(oldTrans), newTrans);
        this.transitionArrayFromStateMap.remove(oldTrans.getFromState());
        this.transitionArrayToStateMap.remove(oldTrans.getToState());
        this.cachedTransitions = null;
        this.distributeTransitionEvent(new AutomataTransitionEvent(this, newTrans, true, false));
    }

    public void removeTransition(Transition trans) {
        this.transitions.remove(trans);
        List l = this.transitionFromStateMap.get(trans.getFromState());
        l.remove(trans);
        l = this.transitionToStateMap.get(trans.getToState());
        l.remove(trans);
        this.transitionArrayFromStateMap.remove(trans.getFromState());
        this.transitionArrayToStateMap.remove(trans.getToState());
        this.cachedTransitions = null;
        this.distributeTransitionEvent(new AutomataTransitionEvent(this, trans, false, false));
    }

    public static List<Object> makeListFromArray(Object[] array) {
        ArrayList<Object> list = new ArrayList<Object>();
        int k = 0;
        while (k < array.length) {
            list.add(array[k]);
            ++k;
        }
        return list;
    }

    public State createState(Point point) {
        int i = 0;
        while (this.getStateWithID(i) != null) {
            ++i;
        }
        State state = new State(i, point, this);
        this.addState(state);
        return state;
    }

    public final State createStateWithId(Point point, int i) {
        State state = new State(i, point, this);
        this.addState(state);
        return state;
    }

    public final void addState(State state) {
        this.states.add(state);
        this.transitionFromStateMap.put(state, new LinkedList());
        this.transitionToStateMap.put(state, new LinkedList());
        this.cachedStates = null;
        this.distributeStateEvent(new AutomataStateEvent(this, state, true, false, false));
    }

    public void removeState(State state) {
        Transition[] t = this.getTransitionsFromState(state);
        int i = 0;
        while (i < t.length) {
            this.removeTransition(t[i]);
            ++i;
        }
        t = this.getTransitionsToState(state);
        i = 0;
        while (i < t.length) {
            this.removeTransition(t[i]);
            ++i;
        }
        this.distributeStateEvent(new AutomataStateEvent(this, state, false, false, false));
        this.states.remove(state);
        this.finalStates.remove(state);
        if (state == this.initialState) {
            this.initialState = null;
        }
        this.transitionFromStateMap.remove(state);
        this.transitionToStateMap.remove(state);
        this.transitionArrayFromStateMap.remove(state);
        this.transitionArrayToStateMap.remove(state);
        this.cachedStates = null;
    }

    public State setInitialState(State initialState) {
        State oldInitialState = this.initialState;
        this.initialState = initialState;
        this.distributeStateEvent(new AutomataStateEvent(this, initialState, false, false, true));
        return oldInitialState;
    }

    public State getInitialState() {
        return this.initialState;
    }

    public State[] getStates() {
        if (this.cachedStates == null) {
            this.cachedStates = this.states.toArray(new State[0]);
            Arrays.sort(this.cachedStates, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((State)o1).getID() - ((State)o2).getID();
                }

                @Override
                public boolean equals(Object o) {
                    return this == o;
                }
            });
        }
        return this.cachedStates;
    }

    public void selectStatesWithinBounds(Rectangle bounds) {
        State[] states = this.getStates();
        int k = 0;
        while (k < states.length) {
            states[k].setSelect(false);
            if (bounds.contains(states[k].getPoint())) {
                states[k].setSelect(true);
            }
            ++k;
        }
    }

    public ArrayList<Note> getNotes() {
        return this.myNotes;
    }

    public void addNote(Note note) {
        this.myNotes.add(note);
        this.distributeNoteEvent(new AutomataNoteEvent(this, note, true, false));
    }

    public void deleteNote(Note note) {
        int k = 0;
        while (k < this.myNotes.size()) {
            if (note == this.myNotes.get(k)) {
                this.myNotes.remove(k);
            }
            ++k;
        }
        this.distributeNoteEvent(new AutomataNoteEvent(this, note, true, false));
    }

    public void addFinalState(State finalState) {
        this.cachedFinalStates = null;
        this.finalStates.add(finalState);
        this.distributeStateEvent(new AutomataStateEvent(this, finalState, false, false, true));
    }

    public void removeFinalState(State state) {
        this.cachedFinalStates = null;
        this.finalStates.remove(state);
        this.distributeStateEvent(new AutomataStateEvent(this, state, false, false, true));
    }

    public State[] getFinalStates() {
        if (this.cachedFinalStates == null) {
            this.cachedFinalStates = this.finalStates.toArray(new State[0]);
        }
        return this.cachedFinalStates;
    }

    public boolean isFinalState(State state) {
        return this.finalStates.contains(state);
    }

    public boolean isInitialState(State state) {
        return state.equals(this.initialState);
    }

    public State getStateWithID(int id) {
        for (State state : this.states) {
            if (state.getID() != id) continue;
            return state;
        }
        return null;
    }

    public boolean isState(State state) {
        return this.states.contains(state);
    }

    protected Class<Transition> getTransitionClass() {
        return Transition.class;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append('\n');
        State[] states = this.getStates();
        int s = 0;
        while (s < states.length) {
            if (this.initialState == states[s]) {
                buffer.append("--> ");
            }
            buffer.append(states[s]);
            if (this.isFinalState(states[s])) {
                buffer.append(" **FINAL**");
            }
            buffer.append('\n');
            Transition[] transitions = this.getTransitionsFromState(states[s]);
            int t = 0;
            while (t < transitions.length) {
                buffer.append('\t');
                buffer.append(transitions[t]);
                buffer.append('\n');
                ++t;
            }
            ++s;
        }
        return buffer.toString();
    }

    public void addStateListener(AutomataStateListener listener) {
        this.stateListeners.add(listener);
    }

    public void addTransitionListener(AutomataTransitionListener listener) {
        this.transitionListeners.add(listener);
    }

    public void addNoteListener(AutomataNoteListener listener) {
        this.noteListeners.add(listener);
    }

    void distributeStateEvent(AutomataStateEvent event) {
        for (AutomataStateListener listener : this.stateListeners) {
            listener.automataStateChange(event);
        }
    }

    public void removeStateListener(AutomataStateListener listener) {
        this.stateListeners.remove(listener);
    }

    public void removeTransitionListener(AutomataTransitionListener listener) {
        this.transitionListeners.remove(listener);
    }

    public void removeNoteListener(AutomataNoteListener listener) {
        this.noteListeners.remove(listener);
    }

    void distributeTransitionEvent(AutomataTransitionEvent event) {
        for (AutomataTransitionListener listener : this.transitionListeners) {
            listener.automataTransitionChange(event);
        }
    }

    void distributeNoteEvent(AutomataNoteEvent event) {
        for (AutomataNoteListener listener : this.noteListeners) {
            listener.automataNoteChange(event);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    public EnvironmentFrame getEnvironmentFrame() {
        return this.myEnvFrame;
    }

    public void setEnvironmentFrame(EnvironmentFrame frame) {
        this.myEnvFrame = frame;
    }

    public void setFilePath(String name) {
        this.fileName = name;
    }

    public String getFileName() {
        int last = this.fileName.lastIndexOf("\\");
        if (last == -1) {
            last = this.fileName.lastIndexOf("/");
        }
        return this.fileName.substring(last + 1);
    }

    public String getFilePath() {
        int last = this.fileName.lastIndexOf("\\");
        if (last == -1) {
            last = this.fileName.lastIndexOf("/");
        }
        return this.fileName.substring(0, last + 1);
    }

    public int hashCode() {
        int ret = 0;
        for (State state : this.states) {
            ret += state.specialHash();
        }
        for (Object object : this.transitions) {
            ret += ((Transition)object).specialHash();
        }
        for (Object object : this.myNotes) {
            ret += ((Note)object).specialHash();
        }
        ret += this.finalStates.hashCode();
        return ret += this.initialState == null ? 0 : (int)((double)this.initialState.specialHash() * Math.PI);
    }

    public void clear() {
        HashSet<Object> t = new HashSet<Object>(this.transitions);
        for (Object o : t) {
            this.removeTransition((Transition)o);
        }
        this.transitions = new HashSet<Object>();
        t = new HashSet<State>(this.states);
        for (Object o : t) {
            this.removeState((State)o);
        }
        this.states = new HashSet<State>();
        this.finalStates = new HashSet<State>();
        this.initialState = null;
        this.cachedStates = null;
        this.cachedTransitions = null;
        this.cachedFinalStates = null;
        this.transitionFromStateMap = new HashMap();
        this.transitionToStateMap = new HashMap();
        this.transitionArrayFromStateMap = new HashMap();
        this.transitionArrayToStateMap = new HashMap();
        while (this.myNotes.size() != 0) {
            AutomatonPane ap = this.myNotes.get(0).getView();
            ap.remove(this.myNotes.get(0));
            ap.repaint();
            this.deleteNote(this.myNotes.get(0));
        }
    }
}

