function example_run
% Here our data has three levels, city level (denoted by x or X); state
% level (denoted by u or U), and country level (denoted by z or Z)
% tr_chunks and te_chunks: variables that store the missing patterns 
% (defined in Definition 3 in the paper) for training and test setmentioned in the paper.
%          Each contains two fields:    1) time: the duration of the missing patterns
%                                       2) value: "'x', [1,1]" means city level
% tr_X, tr_U, tr_Z, and te_X, te_U, te_Z: training and test inputs for
% city, state, and country levels, each row is a sample while each column
% is a feature.
% tr_Y and te_Y: training and test labels.
% is missing, [1,inf] means current level is not missing.
% 

%% load data
load published_data;
[inputs_tr,sizes,XUZ_std] = training_data_formulate(tr_X,tr_U,tr_Z,tr_Y,tr_chunks,5); % the weights of positive obseravations are 5 times than those of negative ones
inputs_te = test_data_formulate(te_X,te_U,te_Z,te_Y,te_chunks,XUZ_std);


%% model training
% oHIML hyper-paramters
alpha = 1;
lambda = 1;

[W]= OLHIML(inputs_tr,sizes.numX,sizes.numU,sizes.numZ,alpha,lambda,0,1);

%% performance testing
X_te = inputs_te{1,1};
Y_te = inputs_te{1,2};

W = W{1,1}{1,1};

[pred_Y,metrics] = predictY(W,X_te,Y_te,0.02,0,0);
[roc_x,roc_y,roc_t,auc] = perfcurve(Y_te,pred_Y,1);

fprintf('AUC:%f\n',auc);
end