function [Ws] = OLHIML(inputs_tr,numX,numU,numZ,alpha,lambda,linear_not_log,l1_not_l21)

numChunks = size(inputs_tr,2);

min_chunk_size=Inf;
for i=1:numChunks
    chunk_size=size(inputs_tr{1,i}{1,1}{1,1},1);
    min_chunk_size=min(min_chunk_size,chunk_size);

    full_X = full(inputs_tr{1,i}{1,1}{1,4});
    norm_X=full_X./repmat(max(full_X),size(full_X,1),1);
    norm_X(isnan(norm_X))=0;
    inputs_tr{1,i}{1,1}{1,4}=sparse(norm_X);
end


%%
MAX_iteration=100;
% round to even number just for convience
batch_size=min_chunk_size/2;
batch_size=2.*round(batch_size/2);

%% online training process
Ws = cell(numChunks,1);
for i=1:numChunks
    Ws{i,1} = {zeros(numX+1,(numU+1),(numZ+1)),[]};
end

eps_pri = 1e-1;% error tolerances
eps_dual = 1e-1;

rho=1;
numCoefs = 10;% number of regularization parameters for 3-order problem.
Thetas = cell(numChunks,numCoefs);
Gammas = cell(numChunks,numCoefs);
for i=1:numCoefs
    for j=1:numChunks
        Thetas{j,i}=zeros(numX+1,numU+1,numZ+1);
        Gammas{j,i}=zeros(numX+1,numU+1,numZ+1);
    end
end

ol_size=0;
for i=1:numChunks
    train_size=size(inputs_tr{1,i}{1,1}{1,1},1);
    ol_size=ol_size+fix(train_size/batch_size);
end

% precompute input for each small batch chunks
ol_inputs_tr=cell(1,ol_size);
c=1;
for i=1:numChunks
    train_size=size(inputs_tr{1,i}{1,1}{1,1},1);
    re_ind = inputs_tr{1,i}{1,2};
    for j=1:fix(train_size/batch_size)
        w = [inputs_tr{1,i}{1,1}{1,4}((j-1)*batch_size/2+1:j*batch_size/2,:);inputs_tr{1,i}{1,1}{1,4}(train_size-j*batch_size/2+1:train_size-(j-1)*batch_size/2,:)];
        Y = [inputs_tr{1,i}{1,1}{1,1}((j-1)*batch_size/2+1:fix(j*batch_size/2),:);inputs_tr{1,i}{1,1}{1,1}(train_size-j*batch_size/2+1:train_size-(j-1)*batch_size/2,:)];
        [u,s,v] = svd(full(w),'econ');
        X_T_Y = w'*Y;
        X_T_X = w'*w;
        input = {Y,X_T_X,X_T_Y,w,u,s,v};
        
        ol_inputs_tr{1,c}={{input,re_ind},i};
        c=c+1;
    end
end


for j=1:MAX_iteration
    
    Thetas_old=Thetas;
    for i=1:ol_size
        [Ws,Thetas,Gammas] = online_interactive_lasso(Ws,Thetas,Gammas,rho,ol_inputs_tr{1,i}(1,1),ol_inputs_tr{1,i}{1,2},numX,numU,numZ,alpha,lambda,linear_not_log,l1_not_l21);% choose classification using logisitc loss
    end
        s_mat = 0;
        r_mat = 0;
        for ii=1:numChunks
            for jj=1:numCoefs
                s_mat = s_mat + sum(sum(sum((rho*(Thetas{ii,jj}-Thetas_old{ii,jj})).^2)));
                r_mat = r_mat + sum(sum(sum(((Ws{ii,1}{1,1}-Thetas_old{ii,jj})).^2)));
            end
        end
        s = sqrt(s_mat);
        r = sqrt(r_mat);

        if(r>2*s)
            rho = 2*rho;
        else
            if(2*r<s)
                rho = rho/2;
            end
        end

        fprintf('iteration:%d\tr:%e\ts:%e\trho:%f\n',j,r,s,rho);
        if(r < eps_pri && s < eps_dual)
            break;
        end
        
end
end