tic;
warning('off','all');
addpath(genpath('DeepLearnToolbox'));

%load dataset
load('china_air.mat');

values = unique(Y);
% class number (output dimension)
k=size(values,1);
% input dimension
d=size(X,3);

% network archtecture: [input_dim, hidden_dim , ... , output_dim]
NN_arch=[d 256 64 16 k];    
% beta: theta constriants co-efficient (selected using validation set)
beta = 0.003;
% learning rate
lr = 0.5;
% output logs
logs = 1;
% maximum iterations
max_iter = 20;

% call the SIMDA model for training & testing
[best_model, CM]=SIMDA(NN_arch, X, Y, beta, latitude, longitude, lr, logs, max_iter);

toc;
warning('on','all');