function [pred_Ys,metrics,city2prediction_dict] = predictLASSO(W,X_te,Y_te,cutoff,locs)
numTasks = size(X_te,2);
numDates = size(X_te{1,1},1);
pred_Ys = zeros(numDates,numTasks);
city2prediction_dict = struct([]);
tp = 0;
fp = 0;
tn = 0;
fn = 0;
for i = 1:numTasks
    tmp_prediction = X_te{1,i}*W(:,i);
    pred_Ys(:,i) = tmp_prediction;
    tp = tp + sum(tmp_prediction >= cutoff & Y_te{1,i} >= cutoff);
    fp = fp + sum(tmp_prediction >= cutoff & Y_te{1,i} < cutoff);
    tn = tn + sum(tmp_prediction <= cutoff & Y_te{1,i} <= cutoff);
    fn = fn + sum(tmp_prediction <= cutoff & Y_te{1,i} > cutoff);
    city2prediction_dict(i).key = locs{1,i};
    city2prediction_dict(i).value = tmp_prediction;
    % city2prediction_dict = setfield(city2prediction_dict,locs{1,i},tmp_prediction);
end
metrics.precision = tp/(tp+fp);
metrics.recall = tp/(tp+fn);