% Unlocbox - Utils
%
%  Norms
%    norm_tv            -  Norm TV in 2 dimentions
%    norm_tv1d          -  Norm TV in 1 dimention
%    norm_tv3d          -  Norm TV in 3 dimentions
%    norm_tv4d          -  Norm TV in 4 dimentions
%    norm_tvnd          -  Norm TV in n dimentions
%    norm_l21           -  Mixed norm L21
%    norm_linf1         -  Mixed norm Linf1
%    norm_nuclear       -  Matrix nuclear norm
%    norm_sumg          -  Sum of norms (compatible with the UNLocBoX)
%
%  Operators
%    gradient_op        -  Gradient in 2 dimentions
%    gradient_op3d      -  Gradient in 1 dimention
%    gradient_op4d      -  Gradient in 4 dimentions
%    gradient_op1d      -  Gradient in 3 dimentions
%    div_op             -  Divergence in 2 dimentions
%    div_op3d           -  Divergence in 1 dimention
%    div_op4d           -  Divergence in 4 dimentions
%    div_op1d           -  Divergence in 3 dimentions
%    laplacian_op       -  Laplacian in 2 dimentions
%    laplacianx_op      -  Laplacian along dimention x
%    laplaciany_op      -  Laplacian along dimention y
%
%  Other
%    snr                -  Signal to noise ratio
%    soft_threshold     -  Soft thresholding operation
%    set_seed           -  Set a new seed
%    vec                -  Vectorize
%    svdecon            -  Acceleleration of svd
%    svdsecon           -  Acceleleration of svds
%    sum_squareform     -  Sparse matrix that sums the squareform of a vector
%    squareform_sp      -  Sparse counterpart of matlab's squareform
%    zero_diag          -  sets the diagonal of a matrix to 0
%
%  For help, bug reports, suggestions etc. please send email to
%  unlocbox (at) groupes (dot) epfl (dot) ch
%
%
%   Url: https://epfl-lts2.github.io/unlocbox-html/doc/utils/Contents.php

% Copyright (C) 2012-2016 Nathanael Perraudin.
% This file is part of UNLOCBOX version 1.7.4
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

% To be done 
% sum_squareform
% squareform_sp


