function [ r ] = DisHLLE(X, Q, varargin)
%DISHLLE rank data using Hessian Eigenmaps
time=cputime;
ip = inputParser;
ip.FunctionName = 'HLLE';
ip.addRequired('X', @ismatrix);
ip.addRequired('Q', @ismatrix);

ip.addOptional('mode', 5, @isnumeric);
ip.addOptional('W', [], @ismatrix);
ip.addOptional('k', 16, @isnumeric);
ip.addOptional('d', 2, @isnumeric);
ip.addOptional('lambda', 0, @isnumeric);
ip.parse(X, Q, varargin{:});
par = ip.Results;
mode = par.mode;
W = par.W;
k = par.k;
d = par.d;
lambda=par.lambda;
if isempty(W)
    W=constructW(X, struct('k', k, 'bSelfConnected', false));
end

[Y, ~] = HLLE(X',k, d);
d = min([size(Y, 1) d]);
eigvector = Y(1:d, :)';
f = eigvector-repmat(eigvector(Q, :), size(eigvector, 1), 1);
f = f.*f;
r = [];
r.f = sqrt(sum(f, 2));
r = computeV(X', r.f, W, lambda);
gdl_draw(X,Q,r.mats,r,mode);
r.time=cputime-time;