function [ dist,x ] = gdl_dist( x, y )
%GDL_DIST compute the distance of two geodesic distances
n=size(x,1);
if x(1,1)<=0 && x(2,1)<=0
    min=0;
    for i=1:n
        if x(i,1)<min
            min=x(i,1);
        end
    end
    for i=1:n
        x(i,1)=x(i,1)-min;
    end
end
maxx=0;
maxy=0;
for i=1:n 
    if x(i,1)>maxx
        maxx=x(i,1);
    end
    if y(i,1)>maxy
        maxy=y(i,1);
    end
end
for i=1:n
   x(i,1)=x(i,1)/maxx;
   y(i,1)=y(i,1)/maxy;
end
sum=0;
for i=1:n
    if y(i,1)~=0
       %sum=sum+abs(x(i,1)/y(i,1)-1);
       sum=sum+abs(x(i,1)-y(i,1));
    end
end
dist=sum/n;
end

