function [ r ] = DisMVU(X, Q, varargin)
%DISMVU rank data using maximum variance unfolding
time=cputime;
ip = inputParser;
ip.FunctionName = 'MVU';
ip.addRequired('X', @ismatrix);
ip.addRequired('Q', @ismatrix);

ip.addOptional('mode', 5, @isnumeric);
ip.addOptional('W', [], @ismatrix);
ip.addOptional('k', 16, @isnumeric);
ip.addOptional('d', 2, @isnumeric);
ip.addOptional('nmarker', 5, @isnumeric);
ip.addOptional('lambda', 0, @isnumeric);
ip.parse(X, Q, varargin{:});
par = ip.Results;
mode = par.mode;
W = par.W;
k = par.k;
d = par.d;
lambda=par.lambda;
nmarker=par.nmarker;
if isempty(W)
    W=constructW(X, struct('k', k, 'bSelfConnected', false));
end

%[Y,Details]= mvu(distance(fea'),knn_k);
[Y,~]=lmvu(distance(X'), nmarker, k);
d = min([size(Y, 1) d]);
eigvector = Y(1:d, :)';
f = eigvector-repmat(eigvector(Q, :), size(eigvector, 1), 1);
f = f.*f;
r = [];
r.f = sqrt(sum(f, 2));
r = computeV(X', r.f, W, lambda);
gdl_draw(X,Q,r.mats,r,mode);
r.time=cputime-time;
end