function [ nf ] = gdl_third_f( mats, Label, nv, lambda2)
%GDL the third step, compute ranking function
%
% Input:
%  - mats: the struct returned by gdl_MakeMats
%  - nv: the new vector field returned by gdl_third_nv
%  - Label: a struct
%      => y: n-by-p vector of labels
%      => mask: n-by-1 logical, true means the point is labeled
%  - lambda2: the parameter c in equation 7
%          
% Output:
%  - f: the ranking function
%
% Example:
%   this function is not meant to be used explicitly, but it is used by GR.m


ip = inputParser;
ip.FunctionName = 'gdl_third_f';
ip.addRequired('mats', @isstruct);
ip.addRequired('Label', @isstruct);
ip.addRequired('nv', @ismatrix);
ip.addRequired('lambda2', @isnumeric);
ip.parse( mats, Label, nv, lambda2 );

% -- linear system
II = diag(double(Label.mask));
S = size(nv);
rev = reshape(nv, S(1) * S(2), 1);
Mtmp = 2 * mats.L + lambda2 * II;
y = mats.beta' * rev;
nf = linsolve(Mtmp,y);

end

