function [ nv ] = gdl_second_nv( v, Q )
%GDL the second step, compute the normalized vector field
%
% Input:
%  - v: the vector field returned by gdl_first_v         
%
% Output:
%  - nv: the new vector field
%
% Example:
%   this function is not meant to be used explicitly, but it is used by GR.m

ip = inputParser;
ip.FunctionName = 'gdl_second_nv';
ip.addRequired('v', @ismatrix);
ip.parse( v );

nv = v;
S = size(nv);
for i = 1:S(2)
   normi=norm(nv(:,i));
   if normi>0
     nv(:,i)=nv(:,i)./normi;
   end
   if i==Q
     nv(:,i)=zeros(S(1),1);
   end;
end

end

