function [ r ] = gdl_draw( X, Q, mats, r, varargin )
%GDL_DRAW draw the ranking results and vector fields
ip = inputParser;
ip.FunctionName = 'mydraw';
ip.addRequired('X', @ismatrix);
ip.addRequired('Q', @ismatrix);
ip.addRequired('mats', @isstruct);
ip.addRequired('r', @isstruct);

ip.addOptional('mode', 5, @isnumeric);
ip.parse(X, Q, mats, r, varargin{:});
par = ip.Results;
mode = par.mode;

if (mode==1)
  if isfield(r,'f')
    figure;
    cla;  
    scatter3(X(:,1), X(:,2), X(:,3), 100, (-1).*r.f, 'filled');
    hold on;
    scatter3(X(Q,1), X(Q,2), X(Q,3), 300, 'k', 'filled');  
    axis tight;
    axis off;
    view(-12,10);
    view(0,90);
  %title('Heat map');
  end
  
elseif (mode==2)
  if isfield(r,'nv')
    figure;
    cla;
    vf = zeros(3, size(X,1));
    for i = 1:size(X, 1)
       vf(:, i) = mats.T(:,:,i) * r.nv(:, i);
    end
    quiver3(X(:,1),X(:,2),X(:,3), vf(1,:)', vf(2,:)', vf(3,:)',1, 'b', 'LineWidth',1);
    hold on;
    scatter3(X(Q,1), X(Q,2), X(Q,3), 300, 'k', 'filled');
    axis tight;
    axis off;
    view(-12,10);
    view(0,90);
    %title('normalized vector field');
  end
elseif (mode == 3)
  if isfield(r,'v')
    figure;
    cla;
    vu = zeros(3, size(X,1));
    for i = 1:size(X, 1)
       vu(:, i) = mats.T(:,:,i) * r.v(:, i);
    end
    quiver3(X(:,1),X(:,2),X(:,3), vu(1,:)', vu(2,:)', vu(3,:)',1, 'b', 'LineWidth',1);
    hold on;
    scatter3(X(Q,1), X(Q,2), X(Q,3), 300, 'k', 'filled');
    axis tight;
    axis off;
    view(-12,10);
    view(0,90);
    %title('Unnormalized vector field'); 
  end

elseif (mode==4)
  if isfield(r,'v0')
    figure;
    cla;
    vp = zeros(3, size(X,1));
    vpt = r.v0;
    for i = 1:size(X, 1)
       vp(:, i) = mats.T(:,:,i) * vpt(:,i);
    end
    quiver3(X(:,1),X(:,2),X(:,3), vp(1,:)', vp(2,:)', vp(3,:)',1, 'b', 'LineWidth',1);
    hold on;
    scatter3(X(Q,1), X(Q,2), X(Q,3), 300, 'k', 'filled');
    axis tight;
    axis off;
    view(-12,10);
    view(0,90);
    %title('Original V^0');
  end
elseif (mode==5)
  figure;
  set(gcf, 'position', [400 500 800 600]);
  
  if isfield(r,'f')
    axes('position', [0.02 0.5 0.45 0.45]);
    cla;
    scatter3(X(:,1), X(:,2), X(:,3), 50, r.f, 'filled');
    hold on;
    scatter3(X(Q,1), X(Q,2), X(Q,3), 100, 'k', 'filled');
    axis tight;
    axis off;
    view(-12,10);
    %view(0,90);
    title('Heat map');
  end
  
  if isfield(r,'nv')
    axes('position', [0.52 0.5 0.45 0.45]);
    cla;
    vf = zeros(3, size(X,1));
    for i = 1:size(X, 1)
       vf(:, i) = mats.T(:,:,i) * r.nv(:, i);
    end
    quiver3(X(:,1),X(:,2),X(:,3), vf(1,:)', vf(2,:)', vf(3,:)',1);
    hold on;
    scatter3(X(Q,1), X(Q,2), X(Q,3), 100, 'k', 'filled');
    axis tight;
    axis off;
    view(-12,10);
    %view(0,90);
    title('normalized vector field');
  end
  
  if isfield(r,'v')
    axes('position', [0.02 0.02 0.45 0.45]);
    cla;
    vu = zeros(3, size(X,1));
    for i = 1:size(X, 1)
       vu(:, i) = mats.T(:,:,i) * r.v(:, i);
    end
    quiver3(X(:,1),X(:,2),X(:,3), vu(1,:)', vu(2,:)', vu(3,:)',1);
    hold on;
    scatter3(X(Q,1), X(Q,2), X(Q,3), 100, 'k', 'filled');
    axis tight;
    axis off;
    view(-12,10);
    %view(0,90);
    title('Unnormalized vector field'); 
  end
  
  if isfield(r,'v0')
    axes('position', [0.52 0.02 0.45 0.45]);
    cla;
    vp = zeros(3, size(X,1));
    vpt = r.v0;
    for i = 1:size(X, 1)
       vp(:, i) = mats.T(:,:,i) * vpt(:,i);
    end
    quiver3(X(:,1),X(:,2),X(:,3), vp(1,:)', vp(2,:)', vp(3,:)',1);
    hold on;
    scatter3(X(Q,1), X(Q,2), X(Q,3), 100, 'k', 'filled');
    axis tight;
    axis off;
    view(-12,10);
    %view(0,90);
    title('Original V^0');
  end
    
end
%view(0,90);
end


