function [ r ] = PR( X, Q, varargin )
%PR rank data using Parallele Field Ranking
time=cputime;
ip = inputParser;
ip.FunctionName = 'PR';
ip.addRequired('X', @ismatrix);
ip.addRequired('Q', @ismatrix);

ip.addOptional('mode', 5, @isnumeric);
ip.addOptional('W', [], @ismatrix);
ip.addOptional('k', 16, @isnumeric);
ip.addOptional('d', 2, @isnumeric);
ip.addOptional('lambda1', 0.01, @isnumeric);
ip.addOptional('lambda2', 0.01, @isnumeric);
ip.addOptional('lambda3', 0.01, @isnumeric);
ip.parse(X, Q, varargin{:});
par = ip.Results;
mode = par.mode;
W = par.W;
k = par.k;
d = par.d;
lambda1 = par.lambda1;
lambda2 = par.lambda2;
lambda3 = par.lambda3;
Y = zeros(size(X,1),1);
Y(Q) = 1;
Label = [];
Label.y = Y;
Label.mask = false(size(X, 1),1);
Label.mask(Q) = true;
if isempty(W)
    W=constructW(X, struct('k', k, 'bSelfConnected', false));
end
mats = PFR_mul_MakeMats(X', d, W, Y, 'use_parfor', false);
r = PFR_mul_RunRank(mats, Label, 'lambda1', lambda1, 'lambda2', lambda2, 'lambda3', lambda3);
r.f=(-1)*r.f;
r.v=(-1)*r.v;
r.nv=(-1)*r.nv;
gdl_draw(X,Q,mats,r,mode);
r.time=cputime-time;

