function [ r ] = Euclidean( X, Q, varargin)
ip = inputParser;
ip.FunctionName = 'Euclidean';
ip.addRequired('X', @ismatrix);
ip.addRequired('Q', @ismatrix);

ip.addOptional('mode', 5, @isnumeric);
ip.addOptional('W', [], @ismatrix);
ip.addOptional('k', 16, @isnumeric);
ip.addOptional('d', 2, @isnumeric);
ip.addOptional('lambda', 0, @isnumeric);
ip.parse(X, Q, varargin{:});
par = ip.Results;
mode = par.mode;
W = par.W;
k = par.k;
d = par.d;
lambda=par.lambda;
if isempty(W)
    W=constructW(X, struct('k', k, 'bSelfConnected', false));
end

f=zeros(size(X,1),1);
for i=1:size(X,1)
    f(i)=EuDist2(X(i,:),X(Q,:));
end
r = [];
r.f = f;
r = computeV(X', r.f, W, lambda);
mydraw(X,Q,r.mats,r,mode);