function [ r ] = svmrank( data, q )
%SVMRANK rank data using libsvm
s=size(data,1);
dist=zeros(s,1);
for i=1:size(data,1)
    dist(i)=EuDist2(data(i,:),data(q,:));
end
[~, I]=sort(dist);
y=[ones(10,1);2*ones(10,1)];
train=[data(I(1:10),:);data(I((s-9):s),:)];
svmstruct=svmtrain(y,train);
w = svmstruct.SVs' * svmstruct.sv_coef;
b = -svmstruct.rho;
d=zeros(s,1);
normw=norm(w);
for i=1:s
   d(i)= (w'*data(i,:)'+b)/normw;
end
r=[];
r.f=d;
r.svmstruct=svmstruct;
end

